@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The properties of an HCX addon
 * @property addonType The type of private cloud addon
 * Expected value is 'HCX'.
 * @property offer The HCX offer, example VMware MaaS Cloud Provider (Enterprise)
 * @property provisioningState The state of the addon provisioning
 */
public data class AddonHcxPropertiesResponse(
    public val addonType: String,
    public val offer: String,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.AddonHcxPropertiesResponse):
            AddonHcxPropertiesResponse = AddonHcxPropertiesResponse(
            addonType = javaType.addonType(),
            offer = javaType.offer(),
            provisioningState = javaType.provisioningState(),
        )
    }
}
