@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A private cloud resource
 * @property availability Properties describing how the cloud is distributed across availability zones
 * @property circuit An ExpressRoute Circuit
 * @property encryption Customer managed key encryption, can be enabled or disabled
 * @property endpoints The endpoints
 * @property externalCloudLinks Array of cloud link IDs from other clouds that connect to this one
 * @property id Resource ID.
 * @property identity The identity of the private cloud, if configured.
 * @property identitySources vCenter Single Sign On Identity Sources
 * @property internet Connectivity to internet is enabled or disabled
 * @property location Resource location
 * @property managementCluster The default cluster used for management
 * @property managementNetwork Network used to access vCenter Server and NSX-T Manager
 * @property name Resource name.
 * @property networkBlock The block of addresses should be unique across VNet in your subscription as well as on-premise. Make sure the CIDR format is conformed to (A.B.C.D/X) where A,B,C,D are between 0 and 255, and X is between 0 and 22
 * @property nsxPublicIpQuotaRaised Flag to indicate whether the private cloud has the quota for provisioned NSX Public IP count raised from 64 to 1024
 * @property nsxtCertificateThumbprint Thumbprint of the NSX-T Manager SSL certificate
 * @property nsxtPassword Optionally, set the NSX-T Manager password when the private cloud is created
 * @property provisioningNetwork Used for virtual machine cold migration, cloning, and snapshot migration
 * @property provisioningState The provisioning state
 * @property secondaryCircuit A secondary expressRoute circuit from a separate AZ. Only present in a stretched private cloud
 * @property sku The private cloud SKU
 * @property tags Resource tags
 * @property type Resource type.
 * @property vcenterCertificateThumbprint Thumbprint of the vCenter Server SSL certificate
 * @property vcenterPassword Optionally, set the vCenter admin password when the private cloud is created
 * @property vmotionNetwork Used for live migration of virtual machines
 */
public data class GetPrivateCloudResult(
    public val availability: AvailabilityPropertiesResponse? = null,
    public val circuit: CircuitResponse? = null,
    public val encryption: EncryptionResponse? = null,
    public val endpoints: EndpointsResponse,
    public val externalCloudLinks: List<String>,
    public val id: String,
    public val identity: PrivateCloudIdentityResponse? = null,
    public val identitySources: List<IdentitySourceResponse>? = null,
    public val internet: String? = null,
    public val location: String,
    public val managementCluster: ManagementClusterResponse,
    public val managementNetwork: String,
    public val name: String,
    public val networkBlock: String,
    public val nsxPublicIpQuotaRaised: String,
    public val nsxtCertificateThumbprint: String,
    public val nsxtPassword: String? = null,
    public val provisioningNetwork: String,
    public val provisioningState: String,
    public val secondaryCircuit: CircuitResponse? = null,
    public val sku: SkuResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vcenterCertificateThumbprint: String,
    public val vcenterPassword: String? = null,
    public val vmotionNetwork: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.GetPrivateCloudResult):
            GetPrivateCloudResult = GetPrivateCloudResult(
            availability = javaType.availability().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.avs.kotlin.outputs.AvailabilityPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            circuit = javaType.circuit().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.avs.kotlin.outputs.CircuitResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.avs.kotlin.outputs.EncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            endpoints = javaType.endpoints().let({ args0 ->
                com.pulumi.azurenative.avs.kotlin.outputs.EndpointsResponse.Companion.toKotlin(args0)
            }),
            externalCloudLinks = javaType.externalCloudLinks().map({ args0 -> args0 }),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.avs.kotlin.outputs.PrivateCloudIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            identitySources = javaType.identitySources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.avs.kotlin.outputs.IdentitySourceResponse.Companion.toKotlin(args0)
                })
            }),
            internet = javaType.internet().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            managementCluster = javaType.managementCluster().let({ args0 ->
                com.pulumi.azurenative.avs.kotlin.outputs.ManagementClusterResponse.Companion.toKotlin(args0)
            }),
            managementNetwork = javaType.managementNetwork(),
            name = javaType.name(),
            networkBlock = javaType.networkBlock(),
            nsxPublicIpQuotaRaised = javaType.nsxPublicIpQuotaRaised(),
            nsxtCertificateThumbprint = javaType.nsxtCertificateThumbprint(),
            nsxtPassword = javaType.nsxtPassword().map({ args0 -> args0 }).orElse(null),
            provisioningNetwork = javaType.provisioningNetwork(),
            provisioningState = javaType.provisioningState(),
            secondaryCircuit = javaType.secondaryCircuit().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.avs.kotlin.outputs.CircuitResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.avs.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vcenterCertificateThumbprint = javaType.vcenterCertificateThumbprint(),
            vcenterPassword = javaType.vcenterPassword().map({ args0 -> args0 }).orElse(null),
            vmotionNetwork = javaType.vmotionNetwork(),
        )
    }
}
