@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * NSX Port Mirroring
 * @property destination Destination VM Group.
 * @property direction Direction of port mirroring profile.
 * @property displayName Display name of the port mirroring profile.
 * @property id Resource ID.
 * @property name Resource name.
 * @property provisioningState The provisioning state
 * @property revision NSX revision number.
 * @property source Source VM Group.
 * @property status Port Mirroring Status.
 * @property type Resource type.
 */
public data class GetWorkloadNetworkPortMirroringResult(
    public val destination: String? = null,
    public val direction: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val revision: Double? = null,
    public val source: String? = null,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.GetWorkloadNetworkPortMirroringResult):
            GetWorkloadNetworkPortMirroringResult = GetWorkloadNetworkPortMirroringResult(
            destination = javaType.destination().map({ args0 -> args0 }).orElse(null),
            direction = javaType.direction().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            revision = javaType.revision().map({ args0 -> args0 }).orElse(null),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
