@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.avs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The properties of a management cluster
 * @property clusterId The identity
 * @property clusterSize The cluster size
 * @property hosts The hosts
 * @property provisioningState The state of the cluster provisioning
 */
public data class ManagementClusterResponse(
    public val clusterId: Int,
    public val clusterSize: Int,
    public val hosts: List<String>? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.avs.outputs.ManagementClusterResponse):
            ManagementClusterResponse = ManagementClusterResponse(
            clusterId = javaType.clusterId(),
            clusterSize = javaType.clusterSize(),
            hosts = javaType.hosts().map({ args0 -> args0 }),
            provisioningState = javaType.provisioningState(),
        )
    }
}
