@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureactivedirectory.kotlin

import com.pulumi.azurenative.azureactivedirectory.AzureactivedirectoryFunctions.getB2CTenantPlain
import com.pulumi.azurenative.azureactivedirectory.AzureactivedirectoryFunctions.getCIAMTenantPlain
import com.pulumi.azurenative.azureactivedirectory.AzureactivedirectoryFunctions.getGuestUsagePlain
import com.pulumi.azurenative.azureactivedirectory.kotlin.inputs.GetB2CTenantPlainArgs
import com.pulumi.azurenative.azureactivedirectory.kotlin.inputs.GetB2CTenantPlainArgsBuilder
import com.pulumi.azurenative.azureactivedirectory.kotlin.inputs.GetCIAMTenantPlainArgs
import com.pulumi.azurenative.azureactivedirectory.kotlin.inputs.GetCIAMTenantPlainArgsBuilder
import com.pulumi.azurenative.azureactivedirectory.kotlin.inputs.GetGuestUsagePlainArgs
import com.pulumi.azurenative.azureactivedirectory.kotlin.inputs.GetGuestUsagePlainArgsBuilder
import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.GetB2CTenantResult
import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.GetCIAMTenantResult
import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.GetGuestUsageResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.GetB2CTenantResult.Companion.toKotlin as getB2CTenantResultToKotlin
import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.GetCIAMTenantResult.Companion.toKotlin as getCIAMTenantResultToKotlin
import com.pulumi.azurenative.azureactivedirectory.kotlin.outputs.GetGuestUsageResult.Companion.toKotlin as getGuestUsageResultToKotlin

public object AzureactivedirectoryFunctions {
    /**
     * Get the Azure AD B2C tenant resource.
     * Azure REST API version: 2021-04-01.
     * Other available API versions: 2019-01-01-preview, 2023-01-18-preview, 2023-05-17-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getB2CTenant(argument: GetB2CTenantPlainArgs): GetB2CTenantResult =
        getB2CTenantResultToKotlin(getB2CTenantPlain(argument.toJava()).await())

    /**
     * @see [getB2CTenant].
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The initial domain name of the Azure AD B2C tenant.
     * @return null
     */
    public suspend fun getB2CTenant(resourceGroupName: String, resourceName: String):
        GetB2CTenantResult {
        val argument = GetB2CTenantPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getB2CTenantResultToKotlin(getB2CTenantPlain(argument.toJava()).await())
    }

    /**
     * @see [getB2CTenant].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azureactivedirectory&#46;kotlin&#46;inputs&#46;GetB2CTenantPlainArgs].
     * @return null
     */
    public suspend fun getB2CTenant(argument: suspend GetB2CTenantPlainArgsBuilder.() -> Unit):
        GetB2CTenantResult {
        val builder = GetB2CTenantPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getB2CTenantResultToKotlin(getB2CTenantPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the Azure AD for customers tenant resource.
     * Azure REST API version: 2023-05-17-preview.
     * @param argument null
     * @return The Azure AD for customers resource.
     */
    public suspend fun getCIAMTenant(argument: GetCIAMTenantPlainArgs): GetCIAMTenantResult =
        getCIAMTenantResultToKotlin(getCIAMTenantPlain(argument.toJava()).await())

    /**
     * @see [getCIAMTenant].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName The initial sub domain of the tenant.
     * @return The Azure AD for customers resource.
     */
    public suspend fun getCIAMTenant(resourceGroupName: String, resourceName: String):
        GetCIAMTenantResult {
        val argument = GetCIAMTenantPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getCIAMTenantResultToKotlin(getCIAMTenantPlain(argument.toJava()).await())
    }

    /**
     * @see [getCIAMTenant].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azureactivedirectory&#46;kotlin&#46;inputs&#46;GetCIAMTenantPlainArgs].
     * @return The Azure AD for customers resource.
     */
    public suspend fun getCIAMTenant(argument: suspend GetCIAMTenantPlainArgsBuilder.() -> Unit):
        GetCIAMTenantResult {
        val builder = GetCIAMTenantPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCIAMTenantResultToKotlin(getCIAMTenantPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Guest Usages resource for the Microsoft.AzureActiveDirectory resource provider
     * Azure REST API version: 2021-04-01.
     * Other available API versions: 2023-01-18-preview, 2023-05-17-preview.
     * @param argument null
     * @return Guest Usages Resource
     */
    public suspend fun getGuestUsage(argument: GetGuestUsagePlainArgs): GetGuestUsageResult =
        getGuestUsageResultToKotlin(getGuestUsagePlain(argument.toJava()).await())

    /**
     * @see [getGuestUsage].
     * @param resourceGroupName The name of the resource group.
     * @param resourceName The initial domain name of the Azure AD B2C tenant.
     * @return Guest Usages Resource
     */
    public suspend fun getGuestUsage(resourceGroupName: String, resourceName: String):
        GetGuestUsageResult {
        val argument = GetGuestUsagePlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getGuestUsageResultToKotlin(getGuestUsagePlain(argument.toJava()).await())
    }

    /**
     * @see [getGuestUsage].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;azureactivedirectory&#46;kotlin&#46;inputs&#46;GetGuestUsagePlainArgs].
     * @return Guest Usages Resource
     */
    public suspend fun getGuestUsage(argument: suspend GetGuestUsagePlainArgsBuilder.() -> Unit):
        GetGuestUsageResult {
        val builder = GetGuestUsagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGuestUsageResultToKotlin(getGuestUsagePlain(builtArgument.toJava()).await())
    }
}
