@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azureactivedirectory.kotlin.inputs

import com.pulumi.azurenative.azureactivedirectory.inputs.GetB2CTenantPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property resourceName The initial domain name of the Azure AD B2C tenant.
 */
public data class GetB2CTenantPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azureactivedirectory.inputs.GetB2CTenantPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azureactivedirectory.inputs.GetB2CTenantPlainArgs =
        com.pulumi.azurenative.azureactivedirectory.inputs.GetB2CTenantPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetB2CTenantPlainArgs].
 */
@PulumiTagMarker
public class GetB2CTenantPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ksjjfypukcwyphks")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The initial domain name of the Azure AD B2C tenant.
     */
    @JvmName("ebpwtwgfgoimqdxp")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetB2CTenantPlainArgs = GetB2CTenantPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
