@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.ActiveDirectoryConnectorArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.ActiveDirectoryConnectorPropertiesArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.ActiveDirectoryConnectorPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Active directory connector resource
 * Azure REST API version: 2023-01-15-preview. Prior API version in Azure Native 1.x: 2022-03-01-preview.
 * ## Example Usage
 * ### Create or update an Active Directory connector instance.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var activeDirectoryConnector = new AzureNative.AzureArcData.ActiveDirectoryConnector("activeDirectoryConnector", new()
 *     {
 *         ActiveDirectoryConnectorName = "testADConnector",
 *         DataControllerName = "testdataController",
 *         Properties = new AzureNative.AzureArcData.Inputs.ActiveDirectoryConnectorPropertiesArgs
 *         {
 *             Spec = new AzureNative.AzureArcData.Inputs.ActiveDirectoryConnectorSpecArgs
 *             {
 *                 ActiveDirectory = new AzureNative.AzureArcData.Inputs.ActiveDirectoryConnectorDomainDetailsArgs
 *                 {
 *                     DomainControllers = new AzureNative.AzureArcData.Inputs.ActiveDirectoryDomainControllersArgs
 *                     {
 *                         PrimaryDomainController = new AzureNative.AzureArcData.Inputs.ActiveDirectoryDomainControllerArgs
 *                         {
 *                             Hostname = "dc1.contoso.local",
 *                         },
 *                         SecondaryDomainControllers = new[]
 *                         {
 *                             new AzureNative.AzureArcData.Inputs.ActiveDirectoryDomainControllerArgs
 *                             {
 *                                 Hostname = "dc2.contoso.local",
 *                             },
 *                             new AzureNative.AzureArcData.Inputs.ActiveDirectoryDomainControllerArgs
 *                             {
 *                                 Hostname = "dc3.contoso.local",
 *                             },
 *                         },
 *                     },
 *                     Realm = "CONTOSO.LOCAL",
 *                     ServiceAccountProvisioning = "manual",
 *                 },
 *                 Dns = new AzureNative.AzureArcData.Inputs.ActiveDirectoryConnectorDNSDetailsArgs
 *                 {
 *                     NameserverIPAddresses = new[]
 *                     {
 *                         "11.11.111.111",
 *                         "22.22.222.222",
 *                     },
 *                     PreferK8sDnsForPtrLookups = false,
 *                     Replicas = 1,
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurearcdata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := azurearcdata.NewActiveDirectoryConnector(ctx, "activeDirectoryConnector", &azurearcdata.ActiveDirectoryConnectorArgs{
 * ActiveDirectoryConnectorName: pulumi.String("testADConnector"),
 * DataControllerName: pulumi.String("testdataController"),
 * Properties: azurearcdata.ActiveDirectoryConnectorPropertiesResponse{
 * Spec: interface{}{
 * ActiveDirectory: interface{}{
 * DomainControllers: interface{}{
 * PrimaryDomainController: &azurearcdata.ActiveDirectoryDomainControllerArgs{
 * Hostname: pulumi.String("dc1.contoso.local"),
 * },
 * SecondaryDomainControllers: azurearcdata.ActiveDirectoryDomainControllerArray{
 * &azurearcdata.ActiveDirectoryDomainControllerArgs{
 * Hostname: pulumi.String("dc2.contoso.local"),
 * },
 * &azurearcdata.ActiveDirectoryDomainControllerArgs{
 * Hostname: pulumi.String("dc3.contoso.local"),
 * },
 * },
 * },
 * Realm: pulumi.String("CONTOSO.LOCAL"),
 * ServiceAccountProvisioning: pulumi.String("manual"),
 * },
 * Dns: &azurearcdata.ActiveDirectoryConnectorDNSDetailsArgs{
 * NameserverIPAddresses: pulumi.StringArray{
 * pulumi.String("11.11.111.111"),
 * pulumi.String("22.22.222.222"),
 * },
 * PreferK8sDnsForPtrLookups: pulumi.Bool(false),
 * Replicas: pulumi.Float64(1),
 * },
 * },
 * },
 * ResourceGroupName: pulumi.String("testrg"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurearcdata.ActiveDirectoryConnector;
 * import com.pulumi.azurenative.azurearcdata.ActiveDirectoryConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var activeDirectoryConnector = new ActiveDirectoryConnector("activeDirectoryConnector", ActiveDirectoryConnectorArgs.builder()
 *             .activeDirectoryConnectorName("testADConnector")
 *             .dataControllerName("testdataController")
 *             .properties(Map.of("spec", Map.ofEntries(
 *                 Map.entry("activeDirectory", Map.ofEntries(
 *                     Map.entry("domainControllers", Map.ofEntries(
 *                         Map.entry("primaryDomainController", Map.of("hostname", "dc1.contoso.local")),
 *                         Map.entry("secondaryDomainControllers",
 *                             Map.of("hostname", "dc2.contoso.local"),
 *                             Map.of("hostname", "dc3.contoso.local"))
 *                     )),
 *                     Map.entry("realm", "CONTOSO.LOCAL"),
 *                     Map.entry("serviceAccountProvisioning", "manual")
 *                 )),
 *                 Map.entry("dns", Map.ofEntries(
 *                     Map.entry("nameserverIPAddresses",
 *                         "11.11.111.111",
 *                         "22.22.222.222"),
 *                     Map.entry("preferK8sDnsForPtrLookups", false),
 *                     Map.entry("replicas", 1)
 *                 ))
 *             )))
 *             .resourceGroupName("testrg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurearcdata:ActiveDirectoryConnector testADConnector /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/dataControllers/{dataControllerName}/activeDirectoryConnectors/{activeDirectoryConnectorName}
 * ```
 * @property activeDirectoryConnectorName The name of the Active Directory connector instance
 * @property dataControllerName The name of the data controller
 * @property properties null
 * @property resourceGroupName The name of the Azure resource group
 */
public data class ActiveDirectoryConnectorArgs(
    public val activeDirectoryConnectorName: Output<String>? = null,
    public val dataControllerName: Output<String>? = null,
    public val properties: Output<ActiveDirectoryConnectorPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.ActiveDirectoryConnectorArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.ActiveDirectoryConnectorArgs =
        com.pulumi.azurenative.azurearcdata.ActiveDirectoryConnectorArgs.builder()
            .activeDirectoryConnectorName(activeDirectoryConnectorName?.applyValue({ args0 -> args0 }))
            .dataControllerName(dataControllerName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActiveDirectoryConnectorArgs].
 */
@PulumiTagMarker
public class ActiveDirectoryConnectorArgsBuilder internal constructor() {
    private var activeDirectoryConnectorName: Output<String>? = null

    private var dataControllerName: Output<String>? = null

    private var properties: Output<ActiveDirectoryConnectorPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the Active Directory connector instance
     */
    @JvmName("muqhwviilgpjagjv")
    public suspend fun activeDirectoryConnectorName(`value`: Output<String>) {
        this.activeDirectoryConnectorName = value
    }

    /**
     * @param value The name of the data controller
     */
    @JvmName("omrkjixghbuskkoa")
    public suspend fun dataControllerName(`value`: Output<String>) {
        this.dataControllerName = value
    }

    /**
     * @param value null
     */
    @JvmName("pdifkgjhcewcxfep")
    public suspend fun properties(`value`: Output<ActiveDirectoryConnectorPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("ulhhhfuferimvvxm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Active Directory connector instance
     */
    @JvmName("wvsmtbulxuojrfkm")
    public suspend fun activeDirectoryConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeDirectoryConnectorName = mapped
    }

    /**
     * @param value The name of the data controller
     */
    @JvmName("xwilsvfoftdfrctw")
    public suspend fun dataControllerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataControllerName = mapped
    }

    /**
     * @param value null
     */
    @JvmName("sbxorkvsembyxmyo")
    public suspend fun properties(`value`: ActiveDirectoryConnectorPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument null
     */
    @JvmName("qrpqarsnourvnqgg")
    public suspend
    fun properties(argument: suspend ActiveDirectoryConnectorPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ActiveDirectoryConnectorPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("oaaiewijqdxjacdv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ActiveDirectoryConnectorArgs = ActiveDirectoryConnectorArgs(
        activeDirectoryConnectorName = activeDirectoryConnectorName,
        dataControllerName = dataControllerName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
