@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.FailoverGroupArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.FailoverGroupPropertiesArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.FailoverGroupPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A failover group resource.
 * Azure REST API version: 2023-01-15-preview.
 * ## Example Usage
 * ### Create or update a failover group instance.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var failoverGroup = new AzureNative.AzureArcData.FailoverGroup("failoverGroup", new()
 *     {
 *         FailoverGroupName = "testFailoverGroupName",
 *         Properties = new AzureNative.AzureArcData.Inputs.FailoverGroupPropertiesArgs
 *         {
 *             PartnerManagedInstanceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.AzureArcData/sqlManagedInstances/partnerMI",
 *             Spec = new AzureNative.AzureArcData.Inputs.FailoverGroupSpecArgs
 *             {
 *                 PartnerSyncMode = "async",
 *                 Role = "primary",
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *         SqlManagedInstanceName = "testSqlManagedInstance",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurearcdata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurearcdata.NewFailoverGroup(ctx, "failoverGroup", &azurearcdata.FailoverGroupArgs{
 * 			FailoverGroupName: pulumi.String("testFailoverGroupName"),
 * 			Properties: azurearcdata.FailoverGroupPropertiesResponse{
 * 				PartnerManagedInstanceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.AzureArcData/sqlManagedInstances/partnerMI"),
 * 				Spec: &azurearcdata.FailoverGroupSpecArgs{
 * 					PartnerSyncMode: pulumi.String("async"),
 * 					Role:            pulumi.String("primary"),
 * 				},
 * 			},
 * 			ResourceGroupName:      pulumi.String("testrg"),
 * 			SqlManagedInstanceName: pulumi.String("testSqlManagedInstance"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurearcdata.FailoverGroup;
 * import com.pulumi.azurenative.azurearcdata.FailoverGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var failoverGroup = new FailoverGroup("failoverGroup", FailoverGroupArgs.builder()
 *             .failoverGroupName("testFailoverGroupName")
 *             .properties(Map.ofEntries(
 *                 Map.entry("partnerManagedInstanceId", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.AzureArcData/sqlManagedInstances/partnerMI"),
 *                 Map.entry("spec", Map.ofEntries(
 *                     Map.entry("partnerSyncMode", "async"),
 *                     Map.entry("role", "primary")
 *                 ))
 *             ))
 *             .resourceGroupName("testrg")
 *             .sqlManagedInstanceName("testSqlManagedInstance")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurearcdata:FailoverGroup testFailoverGroupName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/sqlManagedInstances/{sqlManagedInstanceName}/failoverGroups/{failoverGroupName}
 * ```
 * @property failoverGroupName The name of the Failover Group
 * @property properties null
 * @property resourceGroupName The name of the Azure resource group
 * @property sqlManagedInstanceName Name of SQL Managed Instance
 */
public data class FailoverGroupArgs(
    public val failoverGroupName: Output<String>? = null,
    public val properties: Output<FailoverGroupPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sqlManagedInstanceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.FailoverGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.FailoverGroupArgs =
        com.pulumi.azurenative.azurearcdata.FailoverGroupArgs.builder()
            .failoverGroupName(failoverGroupName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sqlManagedInstanceName(sqlManagedInstanceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FailoverGroupArgs].
 */
@PulumiTagMarker
public class FailoverGroupArgsBuilder internal constructor() {
    private var failoverGroupName: Output<String>? = null

    private var properties: Output<FailoverGroupPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sqlManagedInstanceName: Output<String>? = null

    /**
     * @param value The name of the Failover Group
     */
    @JvmName("dqqllbjcgttoecoq")
    public suspend fun failoverGroupName(`value`: Output<String>) {
        this.failoverGroupName = value
    }

    /**
     * @param value null
     */
    @JvmName("ryyjsmengwqoqaac")
    public suspend fun properties(`value`: Output<FailoverGroupPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("hdmyrudeilfgywvi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of SQL Managed Instance
     */
    @JvmName("slbyshqrnbhwiuhf")
    public suspend fun sqlManagedInstanceName(`value`: Output<String>) {
        this.sqlManagedInstanceName = value
    }

    /**
     * @param value The name of the Failover Group
     */
    @JvmName("qggfkpjldkkghjlw")
    public suspend fun failoverGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverGroupName = mapped
    }

    /**
     * @param value null
     */
    @JvmName("tbsewykepjnqcqkk")
    public suspend fun properties(`value`: FailoverGroupPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument null
     */
    @JvmName("jrvhmjdtimssnrvm")
    public suspend fun properties(argument: suspend FailoverGroupPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = FailoverGroupPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("rfwhpmkbsbgqbvdp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of SQL Managed Instance
     */
    @JvmName("ftqbfhumngqvlvep")
    public suspend fun sqlManagedInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlManagedInstanceName = mapped
    }

    internal fun build(): FailoverGroupArgs = FailoverGroupArgs(
        failoverGroupName = failoverGroupName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sqlManagedInstanceName = sqlManagedInstanceName,
    )
}
