@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.PostgresInstanceArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.PostgresInstancePropertiesArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.PostgresInstancePropertiesArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.PostgresInstanceSkuArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.PostgresInstanceSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A Postgres Instance.
 * Azure REST API version: 2023-01-15-preview. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * ## Example Usage
 * ### Create or update a Postgres Instance.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var postgresInstance = new AzureNative.AzureArcData.PostgresInstance("postgresInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureArcData.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation",
 *             Type = "CustomLocation",
 *         },
 *         Location = "eastus",
 *         PostgresInstanceName = "testpostgresInstance",
 *         Properties = new AzureNative.AzureArcData.Inputs.PostgresInstancePropertiesArgs
 *         {
 *             Admin = "admin",
 *             BasicLoginInformation = new AzureNative.AzureArcData.Inputs.BasicLoginInformationArgs
 *             {
 *                 Password = "********",
 *                 Username = "username",
 *             },
 *             DataControllerId = "dataControllerId",
 *             K8sRaw =
 *             {
 *                 { "apiVersion", "apiVersion" },
 *                 { "kind", "postgresql-12" },
 *                 { "metadata",
 *                 {
 *                     { "creationTimestamp", "2020-08-25T14:55:10Z" },
 *                     { "generation", 1 },
 *                     { "name", "pg1" },
 *                     { "namespace", "test" },
 *                     { "resourceVersion", "527780" },
 *                     { "selfLink", "/apis/arcdata.microsoft.com/v1alpha1/namespaces/test/postgresql-12s/pg1" },
 *                     { "uid", "1111aaaa-ffff-ffff-ffff-99999aaaaaaa" },
 *                 } },
 *                 { "spec",
 *                 {
 *                     { "backups",
 *                     {
 *                         { "deltaMinutes", 3 },
 *                         { "fullMinutes", 10 },
 *                         { "tiers", new[]
 *                         {
 *                             {
 *                                 { "retention",
 *                                 {
 *                                     { "maximums", new[]
 *                                     {
 *                                         "6",
 *                                         "512MB",
 *                                     } },
 *                                     { "minimums", new[]
 *                                     {
 *                                         "3",
 *                                     } },
 *                                 } },
 *                                 { "storage",
 *                                 {
 *                                     { "volumeSize", "1Gi" },
 *                                 } },
 *                             },
 *                         } },
 *                     } },
 *                     { "engine",
 *                     {
 *                         { "extensions", new[]
 *                         {
 *                             {
 *                                 { "name", "citus" },
 *                             },
 *                         } },
 *                     } },
 *                     { "scale",
 *                     {
 *                         { "shards", 3 },
 *                     } },
 *                     { "scheduling",
 *                     {
 *                         { "default",
 *                         {
 *                             { "resources",
 *                             {
 *                                 { "requests",
 *                                 {
 *                                     { "memory", "256Mi" },
 *                                 } },
 *                             } },
 *                         } },
 *                     } },
 *                     { "service",
 *                     {
 *                         { "type", "NodePort" },
 *                     } },
 *                     { "storage",
 *                     {
 *                         { "data",
 *                         {
 *                             { "className", "local-storage" },
 *                             { "size", "5Gi" },
 *                         } },
 *                         { "logs",
 *                         {
 *                             { "className", "local-storage" },
 *                             { "size", "5Gi" },
 *                         } },
 *                     } },
 *                 } },
 *                 { "status",
 *                 {
 *                     { "externalEndpoint", null },
 *                     { "readyPods", "4/4" },
 *                     { "state", "Ready" },
 *                 } },
 *             },
 *         },
 *         ResourceGroupName = "testrg",
 *         Sku = new AzureNative.AzureArcData.Inputs.PostgresInstanceSkuArgs
 *         {
 *             Dev = true,
 *             Name = "default",
 *             Tier = AzureNative.AzureArcData.PostgresInstanceSkuTier.Hyperscale,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurearcdata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurearcdata.NewPostgresInstance(ctx, "postgresInstance", &azurearcdata.PostgresInstanceArgs{
 * 			ExtendedLocation: &azurearcdata.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:             pulumi.String("eastus"),
 * 			PostgresInstanceName: pulumi.String("testpostgresInstance"),
 * 			Properties: azurearcdata.PostgresInstancePropertiesResponse{
 * 				Admin: pulumi.String("admin"),
 * 				BasicLoginInformation: &azurearcdata.BasicLoginInformationArgs{
 * 					Password: pulumi.String("********"),
 * 					Username: pulumi.String("username"),
 * 				},
 * 				DataControllerId: pulumi.String("dataControllerId"),
 * 				K8sRaw: pulumi.Any{
 * 					ApiVersion: "apiVersion",
 * 					Kind:       "postgresql-12",
 * 					Metadata: map[string]interface{}{
 * 						"creationTimestamp": "2020-08-25T14:55:10Z",
 * 						"generation":        1,
 * 						"name":              "pg1",
 * 						"namespace":         "test",
 * 						"resourceVersion":   "527780",
 * 						"selfLink":          "/apis/arcdata.microsoft.com/v1alpha1/namespaces/test/postgresql-12s/pg1",
 * 						"uid":               "1111aaaa-ffff-ffff-ffff-99999aaaaaaa",
 * 					},
 * 					Spec: map[string]interface{}{
 * 						"backups": map[string]interface{}{
 * 							"deltaMinutes": 3,
 * 							"fullMinutes":  10,
 * 							"tiers": []map[string]interface{}{
 * 								map[string]interface{}{
 * 									"retention": map[string]interface{}{
 * 										"maximums": []string{
 * 											"6",
 * 											"512MB",
 * 										},
 * 										"minimums": []string{
 * 											"3",
 * 										},
 * 									},
 * 									"storage": map[string]interface{}{
 * 										"volumeSize": "1Gi",
 * 									},
 * 								},
 * 							},
 * 						},
 * 						"engine": map[string]interface{}{
 * 							"extensions": []map[string]interface{}{
 * 								map[string]interface{}{
 * 									"name": "citus",
 * 								},
 * 							},
 * 						},
 * 						"scale": map[string]interface{}{
 * 							"shards": 3,
 * 						},
 * 						"scheduling": map[string]interface{}{
 * 							"default": map[string]interface{}{
 * 								"resources": map[string]interface{}{
 * 									"requests": map[string]interface{}{
 * 										"memory": "256Mi",
 * 									},
 * 								},
 * 							},
 * 						},
 * 						"service": map[string]interface{}{
 * 							"type": "NodePort",
 * 						},
 * 						"storage": map[string]interface{}{
 * 							"data": map[string]interface{}{
 * 								"className": "local-storage",
 * 								"size":      "5Gi",
 * 							},
 * 							"logs": map[string]interface{}{
 * 								"className": "local-storage",
 * 								"size":      "5Gi",
 * 							},
 * 						},
 * 					},
 * 					Status: map[string]interface{}{
 * 						"externalEndpoint": nil,
 * 						"readyPods":        "4/4",
 * 						"state":            "Ready",
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			Sku: &azurearcdata.PostgresInstanceSkuArgs{
 * 				Dev:  pulumi.Bool(true),
 * 				Name: pulumi.String("default"),
 * 				Tier: azurearcdata.PostgresInstanceSkuTierHyperscale,
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurearcdata.PostgresInstance;
 * import com.pulumi.azurenative.azurearcdata.PostgresInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var postgresInstance = new PostgresInstance("postgresInstance", PostgresInstanceArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("eastus")
 *             .postgresInstanceName("testpostgresInstance")
 *             .properties(Map.ofEntries(
 *                 Map.entry("admin", "admin"),
 *                 Map.entry("basicLoginInformation", Map.ofEntries(
 *                     Map.entry("password", "********"),
 *                     Map.entry("username", "username")
 *                 )),
 *                 Map.entry("dataControllerId", "dataControllerId"),
 *                 Map.entry("k8sRaw", Map.ofEntries(
 *                     Map.entry("apiVersion", "apiVersion"),
 *                     Map.entry("kind", "postgresql-12"),
 *                     Map.entry("metadata", PostgresInstancePropertiesArgs.builder()
 *                         .creationTimestamp("2020-08-25T14:55:10Z")
 *                         .generation(1)
 *                         .name("pg1")
 *                         .namespace("test")
 *                         .resourceVersion("527780")
 *                         .selfLink("/apis/arcdata.microsoft.com/v1alpha1/namespaces/test/postgresql-12s/pg1")
 *                         .uid("1111aaaa-ffff-ffff-ffff-99999aaaaaaa")
 *                         .build()),
 *                     Map.entry("spec", PostgresInstancePropertiesArgs.builder()
 *                         .backups(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .engine(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .scale(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .scheduling(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .service(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .storage(%!v(PANIC=Format method: runtime error: invalid memory address or nil pointer dereference))
 *                         .build()),
 *                     Map.entry("status", PostgresInstancePropertiesArgs.builder()
 *                         .externalEndpoint(null)
 *                         .readyPods("4/4")
 *                         .state("Ready")
 *                         .build())
 *                 ))
 *             ))
 *             .resourceGroupName("testrg")
 *             .sku(Map.ofEntries(
 *                 Map.entry("dev", true),
 *                 Map.entry("name", "default"),
 *                 Map.entry("tier", "Hyperscale")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurearcdata:PostgresInstance testpostgresInstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/postgresInstances/{postgresInstanceName}
 * ```
 * @property extendedLocation The extendedLocation of the resource.
 * @property location The geo-location where the resource lives
 * @property postgresInstanceName Name of Postgres Instance
 * @property properties null
 * @property resourceGroupName The name of the Azure resource group
 * @property sku Resource sku.
 * @property tags Resource tags.
 */
public data class PostgresInstanceArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val postgresInstanceName: Output<String>? = null,
    public val properties: Output<PostgresInstancePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<PostgresInstanceSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.PostgresInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.PostgresInstanceArgs =
        com.pulumi.azurenative.azurearcdata.PostgresInstanceArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .postgresInstanceName(postgresInstanceName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PostgresInstanceArgs].
 */
@PulumiTagMarker
public class PostgresInstanceArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var postgresInstanceName: Output<String>? = null

    private var properties: Output<PostgresInstancePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<PostgresInstanceSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("yyucnxgiqxetotnm")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gvksjfqocqgrbfsv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of Postgres Instance
     */
    @JvmName("bongpxvxwuojbaej")
    public suspend fun postgresInstanceName(`value`: Output<String>) {
        this.postgresInstanceName = value
    }

    /**
     * @param value null
     */
    @JvmName("riwqxihptnuvvqvt")
    public suspend fun properties(`value`: Output<PostgresInstancePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("tukcsjowhiiyvnig")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource sku.
     */
    @JvmName("hjvdeojxefuuuqci")
    public suspend fun sku(`value`: Output<PostgresInstanceSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("weocvudkvjgheyae")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("ifvllsgtesltcgtx")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extendedLocation of the resource.
     */
    @JvmName("nohjsxupvrnlgwox")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gufmyoxppuwxnjng")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of Postgres Instance
     */
    @JvmName("mkpktdytjqmuqkux")
    public suspend fun postgresInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postgresInstanceName = mapped
    }

    /**
     * @param value null
     */
    @JvmName("easxjixqywgolhab")
    public suspend fun properties(`value`: PostgresInstancePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument null
     */
    @JvmName("uaxxchrieqwnuabq")
    public suspend
    fun properties(argument: suspend PostgresInstancePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PostgresInstancePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("onwubxmevtlnegms")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource sku.
     */
    @JvmName("uuqqvsdjtvotyxwv")
    public suspend fun sku(`value`: PostgresInstanceSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Resource sku.
     */
    @JvmName("rnqecpffvbpsojla")
    public suspend fun sku(argument: suspend PostgresInstanceSkuArgsBuilder.() -> Unit) {
        val toBeMapped = PostgresInstanceSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("leswmqbsjffuhuxg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ipjhnbycfvutoyfo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PostgresInstanceArgs = PostgresInstanceArgs(
        extendedLocation = extendedLocation,
        location = location,
        postgresInstanceName = postgresInstanceName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
