@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin

import com.pulumi.azurenative.azurearcdata.SqlManagedInstanceArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.SqlManagedInstancePropertiesArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.SqlManagedInstancePropertiesArgsBuilder
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.SqlManagedInstanceSkuArgs
import com.pulumi.azurenative.azurearcdata.kotlin.inputs.SqlManagedInstanceSkuArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A SqlManagedInstance.
 * Azure REST API version: 2023-01-15-preview. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * ## Example Usage
 * ### Create or update a SQL Managed Instance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlManagedInstance = new AzureNative.AzureArcData.SqlManagedInstance("sqlManagedInstance", new()
 *     {
 *         ExtendedLocation = new AzureNative.AzureArcData.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation",
 *             Type = "CustomLocation",
 *         },
 *         Location = "northeurope",
 *         Properties = new AzureNative.AzureArcData.Inputs.SqlManagedInstancePropertiesArgs
 *         {
 *             ActiveDirectoryInformation = new AzureNative.AzureArcData.Inputs.ActiveDirectoryInformationArgs
 *             {
 *                 KeytabInformation = new AzureNative.AzureArcData.Inputs.KeytabInformationArgs
 *                 {
 *                     Keytab = "********",
 *                 },
 *             },
 *             Admin = "Admin user",
 *             BasicLoginInformation = new AzureNative.AzureArcData.Inputs.BasicLoginInformationArgs
 *             {
 *                 Password = "********",
 *                 Username = "username",
 *             },
 *             ClusterId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s",
 *             EndTime = "Instance end time",
 *             ExtensionId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s/providers/Microsoft.KubernetesConfiguration/extensions/extension",
 *             K8sRaw = new AzureNative.AzureArcData.Inputs.SqlManagedInstanceK8sRawArgs
 *             {
 *                 Spec = new AzureNative.AzureArcData.Inputs.SqlManagedInstanceK8sSpecArgs
 *                 {
 *                     Replicas = 1,
 *                     Scheduling = new AzureNative.AzureArcData.Inputs.K8sSchedulingArgs
 *                     {
 *                         Default = new AzureNative.AzureArcData.Inputs.K8sSchedulingOptionsArgs
 *                         {
 *                             Resources = new AzureNative.AzureArcData.Inputs.K8sResourceRequirementsArgs
 *                             {
 *                                 Limits =
 *                                 {
 *                                     { "additionalProperty", "additionalValue" },
 *                                     { "cpu", "1" },
 *                                     { "memory", "8Gi" },
 *                                 },
 *                                 Requests =
 *                                 {
 *                                     { "additionalProperty", "additionalValue" },
 *                                     { "cpu", "1" },
 *                                     { "memory", "8Gi" },
 *                                 },
 *                             },
 *                         },
 *                     },
 *                     Security = new AzureNative.AzureArcData.Inputs.K8sSecurityArgs
 *                     {
 *                         ActiveDirectory = new AzureNative.AzureArcData.Inputs.K8sActiveDirectoryArgs
 *                         {
 *                             AccountName = "Account name",
 *                             Connector = new AzureNative.AzureArcData.Inputs.K8sActiveDirectoryConnectorArgs
 *                             {
 *                                 Name = "Name of connector",
 *                                 Namespace = "Namespace of connector",
 *                             },
 *                             EncryptionTypes = new[]
 *                             {
 *                                 "Encryption type item1, Encryption type item2,...",
 *                             },
 *                             KeytabSecret = "Key tab secret of account",
 *                         },
 *                         AdminLoginSecret = "test-sql-login-secret",
 *                         ServiceCertificateSecret = "Service Certificate Secret",
 *                         TransparentDataEncryption = new AzureNative.AzureArcData.Inputs.K8stransparentDataEncryptionArgs
 *                         {
 *                             Mode = "SystemManaged",
 *                         },
 *                     },
 *                     Settings = new AzureNative.AzureArcData.Inputs.K8sSettingsArgs
 *                     {
 *                         Network = new AzureNative.AzureArcData.Inputs.K8sNetworkSettingsArgs
 *                         {
 *                             Forceencryption = 0,
 *                             Tlsciphers = "ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-AES128-SHA256:ECDHE-ECDSA-AES256-SHA384:ECDHE-RSA-AES128-SHA256:ECDHE-RSA-AES256-SHA384",
 *                             Tlsprotocols = "1.2",
 *                         },
 *                     },
 *                 },
 *             },
 *             LicenseType = "LicenseIncluded",
 *             StartTime = "Instance start time",
 *         },
 *         ResourceGroupName = "testrg",
 *         Sku = new AzureNative.AzureArcData.Inputs.SqlManagedInstanceSkuArgs
 *         {
 *             Dev = true,
 *             Name = AzureNative.AzureArcData.SqlManagedInstanceSkuName.VCore,
 *             Tier = AzureNative.AzureArcData.SqlManagedInstanceSkuTier.GeneralPurpose,
 *         },
 *         SqlManagedInstanceName = "testsqlManagedInstance",
 *         Tags =
 *         {
 *             { "mytag", "myval" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurearcdata/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := azurearcdata.NewSqlManagedInstance(ctx, "sqlManagedInstance", &azurearcdata.SqlManagedInstanceArgs{
 * ExtendedLocation: &azurearcdata.ExtendedLocationArgs{
 * Name: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation"),
 * Type: pulumi.String("CustomLocation"),
 * },
 * Location: pulumi.String("northeurope"),
 * Properties: azurearcdata.SqlManagedInstancePropertiesResponse{
 * ActiveDirectoryInformation: &azurearcdata.ActiveDirectoryInformationArgs{
 * KeytabInformation: &azurearcdata.KeytabInformationArgs{
 * Keytab: pulumi.String("********"),
 * },
 * },
 * Admin: pulumi.String("Admin user"),
 * BasicLoginInformation: &azurearcdata.BasicLoginInformationArgs{
 * Password: pulumi.String("********"),
 * Username: pulumi.String("username"),
 * },
 * ClusterId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s"),
 * EndTime: pulumi.String("Instance end time"),
 * ExtensionId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s/providers/Microsoft.KubernetesConfiguration/extensions/extension"),
 * K8sRaw: interface{}{
 * Spec: interface{}{
 * Replicas: pulumi.Int(1),
 * Scheduling: interface{}{
 * Default: interface{}{
 * Resources: &azurearcdata.K8sResourceRequirementsArgs{
 * Limits: pulumi.StringMap{
 * "additionalProperty": pulumi.String("additionalValue"),
 * "cpu": pulumi.String("1"),
 * "memory": pulumi.String("8Gi"),
 * },
 * Requests: pulumi.StringMap{
 * "additionalProperty": pulumi.String("additionalValue"),
 * "cpu": pulumi.String("1"),
 * "memory": pulumi.String("8Gi"),
 * },
 * },
 * },
 * },
 * Security: interface{}{
 * ActiveDirectory: interface{}{
 * AccountName: pulumi.String("Account name"),
 * Connector: &azurearcdata.K8sActiveDirectoryConnectorArgs{
 * Name: pulumi.String("Name of connector"),
 * Namespace: pulumi.String("Namespace of connector"),
 * },
 * EncryptionTypes: pulumi.StringArray{
 * pulumi.String("Encryption type item1, Encryption type item2,..."),
 * },
 * KeytabSecret: pulumi.String("Key tab secret of account"),
 * },
 * AdminLoginSecret: pulumi.String("test-sql-login-secret"),
 * ServiceCertificateSecret: pulumi.String("Service Certificate Secret"),
 * TransparentDataEncryption: &azurearcdata.K8stransparentDataEncryptionArgs{
 * Mode: pulumi.String("SystemManaged"),
 * },
 * },
 * Settings: interface{}{
 * Network: &azurearcdata.K8sNetworkSettingsArgs{
 * Forceencryption: pulumi.Int(0),
 * Tlsciphers: pulumi.String("ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-AES128-SHA256:ECDHE-ECDSA-AES256-SHA384:ECDHE-RSA-AES128-SHA256:ECDHE-RSA-AES256-SHA384"),
 * Tlsprotocols: pulumi.String("1.2"),
 * },
 * },
 * },
 * },
 * LicenseType: pulumi.String("LicenseIncluded"),
 * StartTime: pulumi.String("Instance start time"),
 * },
 * ResourceGroupName: pulumi.String("testrg"),
 * Sku: &azurearcdata.SqlManagedInstanceSkuArgs{
 * Dev: pulumi.Bool(true),
 * Name: azurearcdata.SqlManagedInstanceSkuNameVCore,
 * Tier: azurearcdata.SqlManagedInstanceSkuTierGeneralPurpose,
 * },
 * SqlManagedInstanceName: pulumi.String("testsqlManagedInstance"),
 * Tags: pulumi.StringMap{
 * "mytag": pulumi.String("myval"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurearcdata.SqlManagedInstance;
 * import com.pulumi.azurenative.azurearcdata.SqlManagedInstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlManagedInstance = new SqlManagedInstance("sqlManagedInstance", SqlManagedInstanceArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.ExtendedLocation/customLocations/arclocation"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("northeurope")
 *             .properties(Map.ofEntries(
 *                 Map.entry("activeDirectoryInformation", Map.of("keytabInformation", Map.of("keytab", "********"))),
 *                 Map.entry("admin", "Admin user"),
 *                 Map.entry("basicLoginInformation", Map.ofEntries(
 *                     Map.entry("password", "********"),
 *                     Map.entry("username", "username")
 *                 )),
 *                 Map.entry("clusterId", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s"),
 *                 Map.entry("endTime", "Instance end time"),
 *                 Map.entry("extensionId", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Kubernetes/connectedClusters/connectedk8s/providers/Microsoft.KubernetesConfiguration/extensions/extension"),
 *                 Map.entry("k8sRaw", Map.of("spec", Map.ofEntries(
 *                     Map.entry("replicas", 1),
 *                     Map.entry("scheduling", Map.of("default", Map.of("resources", Map.ofEntries(
 *                         Map.entry("limits", Map.ofEntries(
 *                             Map.entry("additionalProperty", "additionalValue"),
 *                             Map.entry("cpu", "1"),
 *                             Map.entry("memory", "8Gi")
 *                         )),
 *                         Map.entry("requests", Map.ofEntries(
 *                             Map.entry("additionalProperty", "additionalValue"),
 *                             Map.entry("cpu", "1"),
 *                             Map.entry("memory", "8Gi")
 *                         ))
 *                     )))),
 *                     Map.entry("security", Map.ofEntries(
 *                         Map.entry("activeDirectory", Map.ofEntries(
 *                             Map.entry("accountName", "Account name"),
 *                             Map.entry("connector", Map.ofEntries(
 *                                 Map.entry("name", "Name of connector"),
 *                                 Map.entry("namespace", "Namespace of connector")
 *                             )),
 *                             Map.entry("encryptionTypes", "Encryption type item1, Encryption type item2,..."),
 *                             Map.entry("keytabSecret", "Key tab secret of account")
 *                         )),
 *                         Map.entry("adminLoginSecret", "test-sql-login-secret"),
 *                         Map.entry("serviceCertificateSecret", "Service Certificate Secret"),
 *                         Map.entry("transparentDataEncryption", Map.of("mode", "SystemManaged"))
 *                     )),
 *                     Map.entry("settings", Map.of("network", Map.ofEntries(
 *                         Map.entry("forceencryption", 0),
 *                         Map.entry("tlsciphers", "ECDHE-ECDSA-AES128-GCM-SHA256:ECDHE-ECDSA-AES256-GCM-SHA384:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-RSA-AES256-GCM-SHA384:ECDHE-ECDSA-AES128-SHA256:ECDHE-ECDSA-AES256-SHA384:ECDHE-RSA-AES128-SHA256:ECDHE-RSA-AES256-SHA384"),
 *                         Map.entry("tlsprotocols", "1.2")
 *                     )))
 *                 ))),
 *                 Map.entry("licenseType", "LicenseIncluded"),
 *                 Map.entry("startTime", "Instance start time")
 *             ))
 *             .resourceGroupName("testrg")
 *             .sku(Map.ofEntries(
 *                 Map.entry("dev", true),
 *                 Map.entry("name", "vCore"),
 *                 Map.entry("tier", "GeneralPurpose")
 *             ))
 *             .sqlManagedInstanceName("testsqlManagedInstance")
 *             .tags(Map.of("mytag", "myval"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurearcdata:SqlManagedInstance testsqlManagedInstance /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureArcData/sqlManagedInstances/{sqlManagedInstanceName}
 * ```
 * @property extendedLocation The extendedLocation of the resource.
 * @property location The geo-location where the resource lives
 * @property properties null
 * @property resourceGroupName The name of the Azure resource group
 * @property sku Resource sku.
 * @property sqlManagedInstanceName Name of SQL Managed Instance
 * @property tags Resource tags.
 */
public data class SqlManagedInstanceArgs(
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<SqlManagedInstancePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SqlManagedInstanceSkuArgs>? = null,
    public val sqlManagedInstanceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.SqlManagedInstanceArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.SqlManagedInstanceArgs =
        com.pulumi.azurenative.azurearcdata.SqlManagedInstanceArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sqlManagedInstanceName(sqlManagedInstanceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SqlManagedInstanceArgs].
 */
@PulumiTagMarker
public class SqlManagedInstanceArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var properties: Output<SqlManagedInstancePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SqlManagedInstanceSkuArgs>? = null

    private var sqlManagedInstanceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("yluxtmphsjygsjok")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("agmxolmpmxcjolgx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value null
     */
    @JvmName("jewktwyqqiyayoeb")
    public suspend fun properties(`value`: Output<SqlManagedInstancePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("sgoklbjytlqhowea")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource sku.
     */
    @JvmName("dxsgsxsmkxpfrqff")
    public suspend fun sku(`value`: Output<SqlManagedInstanceSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Name of SQL Managed Instance
     */
    @JvmName("xoukiqxsfdchurdm")
    public suspend fun sqlManagedInstanceName(`value`: Output<String>) {
        this.sqlManagedInstanceName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pamjvkdtwijuiapi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("nsdyhfuqardpiiey")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extendedLocation of the resource.
     */
    @JvmName("scqqjsvcdxkrydtx")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("pgwiselinopsueig")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value null
     */
    @JvmName("iyxnrlyfokolrkht")
    public suspend fun properties(`value`: SqlManagedInstancePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument null
     */
    @JvmName("jmgtpeulxbcfenrc")
    public suspend
    fun properties(argument: suspend SqlManagedInstancePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SqlManagedInstancePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("kluewpeuaxpfwtvq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource sku.
     */
    @JvmName("egyqkntqjqlogdub")
    public suspend fun sku(`value`: SqlManagedInstanceSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument Resource sku.
     */
    @JvmName("ufocnmslltineiwq")
    public suspend fun sku(argument: suspend SqlManagedInstanceSkuArgsBuilder.() -> Unit) {
        val toBeMapped = SqlManagedInstanceSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Name of SQL Managed Instance
     */
    @JvmName("dlvxokisfymgvaac")
    public suspend fun sqlManagedInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlManagedInstanceName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("grhircoirbwasjdu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("yulkijlqavathtem")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SqlManagedInstanceArgs = SqlManagedInstanceArgs(
        extendedLocation = extendedLocation,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        sku = sku,
        sqlManagedInstanceName = sqlManagedInstanceName,
        tags = tags,
    )
}
