@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The infrastructure the data controller is running on.
 */
public enum class Infrastructure(
    public val javaValue: com.pulumi.azurenative.azurearcdata.enums.Infrastructure,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.enums.Infrastructure> {
    Azure(com.pulumi.azurenative.azurearcdata.enums.Infrastructure.Azure),
    Gcp(com.pulumi.azurenative.azurearcdata.enums.Infrastructure.Gcp),
    Aws(com.pulumi.azurenative.azurearcdata.enums.Infrastructure.Aws),
    Alibaba(com.pulumi.azurenative.azurearcdata.enums.Infrastructure.Alibaba),
    Onpremises(com.pulumi.azurenative.azurearcdata.enums.Infrastructure.Onpremises),
    Other(com.pulumi.azurenative.azurearcdata.enums.Infrastructure.Other),
    ;

    override fun toJava(): com.pulumi.azurenative.azurearcdata.enums.Infrastructure = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.enums.Infrastructure):
            Infrastructure = Infrastructure.values().first { it.javaValue == javaType }
    }
}
