@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of an Active Directory connector resource
 * @property domainServiceAccountLoginInformation Username and password for domain service account authentication.
 * @property spec null
 * @property status null
 */
public data class ActiveDirectoryConnectorPropertiesArgs(
    public val domainServiceAccountLoginInformation: Output<BasicLoginInformationArgs>? = null,
    public val spec: Output<ActiveDirectoryConnectorSpecArgs>,
    public val status: Output<ActiveDirectoryConnectorStatusArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorPropertiesArgs =
        com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorPropertiesArgs.builder()
            .domainServiceAccountLoginInformation(
                domainServiceAccountLoginInformation?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .spec(spec.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(status?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ActiveDirectoryConnectorPropertiesArgs].
 */
@PulumiTagMarker
public class ActiveDirectoryConnectorPropertiesArgsBuilder internal constructor() {
    private var domainServiceAccountLoginInformation: Output<BasicLoginInformationArgs>? = null

    private var spec: Output<ActiveDirectoryConnectorSpecArgs>? = null

    private var status: Output<ActiveDirectoryConnectorStatusArgs>? = null

    /**
     * @param value Username and password for domain service account authentication.
     */
    @JvmName("khqlciixtgttpwrg")
    public suspend
    fun domainServiceAccountLoginInformation(`value`: Output<BasicLoginInformationArgs>) {
        this.domainServiceAccountLoginInformation = value
    }

    /**
     * @param value null
     */
    @JvmName("ysfukecnmprltyjf")
    public suspend fun spec(`value`: Output<ActiveDirectoryConnectorSpecArgs>) {
        this.spec = value
    }

    /**
     * @param value null
     */
    @JvmName("vccitlxpswhtrqcr")
    public suspend fun status(`value`: Output<ActiveDirectoryConnectorStatusArgs>) {
        this.status = value
    }

    /**
     * @param value Username and password for domain service account authentication.
     */
    @JvmName("hjmsqrjaykctfosu")
    public suspend fun domainServiceAccountLoginInformation(`value`: BasicLoginInformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainServiceAccountLoginInformation = mapped
    }

    /**
     * @param argument Username and password for domain service account authentication.
     */
    @JvmName("dgxhrkvyvdeqljpq")
    public suspend
    fun domainServiceAccountLoginInformation(argument: suspend BasicLoginInformationArgsBuilder.() -> Unit) {
        val toBeMapped = BasicLoginInformationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.domainServiceAccountLoginInformation = mapped
    }

    /**
     * @param value null
     */
    @JvmName("jmlworgflncpwwxf")
    public suspend fun spec(`value`: ActiveDirectoryConnectorSpecArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.spec = mapped
    }

    /**
     * @param argument null
     */
    @JvmName("dcydsxxbhnyouxvi")
    public suspend fun spec(argument: suspend ActiveDirectoryConnectorSpecArgsBuilder.() -> Unit) {
        val toBeMapped = ActiveDirectoryConnectorSpecArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.spec = mapped
    }

    /**
     * @param value null
     */
    @JvmName("josbrryebkabihdl")
    public suspend fun status(`value`: ActiveDirectoryConnectorStatusArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param argument null
     */
    @JvmName("iqyadshboxxanism")
    public suspend
    fun status(argument: suspend ActiveDirectoryConnectorStatusArgsBuilder.() -> Unit) {
        val toBeMapped = ActiveDirectoryConnectorStatusArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.status = mapped
    }

    internal fun build(): ActiveDirectoryConnectorPropertiesArgs =
        ActiveDirectoryConnectorPropertiesArgs(
            domainServiceAccountLoginInformation = domainServiceAccountLoginInformation,
            spec = spec ?: throw PulumiNullFieldException("spec"),
            status = status,
        )
}
