@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The specifications of the AD Kubernetes resource.
 * @property activeDirectory null
 * @property dns null
 */
public data class ActiveDirectoryConnectorSpecArgs(
    public val activeDirectory: Output<ActiveDirectoryConnectorDomainDetailsArgs>,
    public val dns: Output<ActiveDirectoryConnectorDNSDetailsArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorSpecArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorSpecArgs =
        com.pulumi.azurenative.azurearcdata.inputs.ActiveDirectoryConnectorSpecArgs.builder()
            .activeDirectory(activeDirectory.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dns(dns.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ActiveDirectoryConnectorSpecArgs].
 */
@PulumiTagMarker
public class ActiveDirectoryConnectorSpecArgsBuilder internal constructor() {
    private var activeDirectory: Output<ActiveDirectoryConnectorDomainDetailsArgs>? = null

    private var dns: Output<ActiveDirectoryConnectorDNSDetailsArgs>? = null

    /**
     * @param value null
     */
    @JvmName("fmbmkhtiwenkvoey")
    public suspend fun activeDirectory(`value`: Output<ActiveDirectoryConnectorDomainDetailsArgs>) {
        this.activeDirectory = value
    }

    /**
     * @param value null
     */
    @JvmName("sywipuestxsvnkqe")
    public suspend fun dns(`value`: Output<ActiveDirectoryConnectorDNSDetailsArgs>) {
        this.dns = value
    }

    /**
     * @param value null
     */
    @JvmName("fayuukwdckfjbqjq")
    public suspend fun activeDirectory(`value`: ActiveDirectoryConnectorDomainDetailsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activeDirectory = mapped
    }

    /**
     * @param argument null
     */
    @JvmName("gnirirynykmjpusw")
    public suspend
    fun activeDirectory(argument: suspend ActiveDirectoryConnectorDomainDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ActiveDirectoryConnectorDomainDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.activeDirectory = mapped
    }

    /**
     * @param value null
     */
    @JvmName("shuhduienlyxmian")
    public suspend fun dns(`value`: ActiveDirectoryConnectorDNSDetailsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dns = mapped
    }

    /**
     * @param argument null
     */
    @JvmName("eavsopcwnqtniopm")
    public suspend
    fun dns(argument: suspend ActiveDirectoryConnectorDNSDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = ActiveDirectoryConnectorDNSDetailsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dns = mapped
    }

    internal fun build(): ActiveDirectoryConnectorSpecArgs = ActiveDirectoryConnectorSpecArgs(
        activeDirectory = activeDirectory ?: throw PulumiNullFieldException("activeDirectory"),
        dns = dns ?: throw PulumiNullFieldException("dns"),
    )
}
