@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.GetDataControllerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataControllerName The name of the data controller
 * @property resourceGroupName The name of the Azure resource group
 */
public data class GetDataControllerPlainArgs(
    public val dataControllerName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.GetDataControllerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.GetDataControllerPlainArgs =
        com.pulumi.azurenative.azurearcdata.inputs.GetDataControllerPlainArgs.builder()
            .dataControllerName(dataControllerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataControllerPlainArgs].
 */
@PulumiTagMarker
public class GetDataControllerPlainArgsBuilder internal constructor() {
    private var dataControllerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the data controller
     */
    @JvmName("qchfcfitdrmvkaye")
    public suspend fun dataControllerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataControllerName = mapped
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("vkhrjhqvjkrrpmne")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDataControllerPlainArgs = GetDataControllerPlainArgs(
        dataControllerName = dataControllerName ?: throw PulumiNullFieldException("dataControllerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
