@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.GetSqlServerDatabasePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName Name of the database
 * @property resourceGroupName The name of the Azure resource group
 * @property sqlServerInstanceName Name of SQL Server Instance
 */
public data class GetSqlServerDatabasePlainArgs(
    public val databaseName: String,
    public val resourceGroupName: String,
    public val sqlServerInstanceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.GetSqlServerDatabasePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.GetSqlServerDatabasePlainArgs =
        com.pulumi.azurenative.azurearcdata.inputs.GetSqlServerDatabasePlainArgs.builder()
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sqlServerInstanceName(sqlServerInstanceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlServerDatabasePlainArgs].
 */
@PulumiTagMarker
public class GetSqlServerDatabasePlainArgsBuilder internal constructor() {
    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    private var sqlServerInstanceName: String? = null

    /**
     * @param value Name of the database
     */
    @JvmName("vepnrenwvfeyjyfi")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("obbhjhoccyrdcgob")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of SQL Server Instance
     */
    @JvmName("ibgoninknmrmcglu")
    public suspend fun sqlServerInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlServerInstanceName = mapped
    }

    internal fun build(): GetSqlServerDatabasePlainArgs = GetSqlServerDatabasePlainArgs(
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sqlServerInstanceName = sqlServerInstanceName ?: throw
            PulumiNullFieldException("sqlServerInstanceName"),
    )
}
