@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.GetSqlServerInstancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the Azure resource group
 * @property sqlServerInstanceName Name of SQL Server Instance
 */
public data class GetSqlServerInstancePlainArgs(
    public val resourceGroupName: String,
    public val sqlServerInstanceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.GetSqlServerInstancePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.GetSqlServerInstancePlainArgs =
        com.pulumi.azurenative.azurearcdata.inputs.GetSqlServerInstancePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sqlServerInstanceName(sqlServerInstanceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlServerInstancePlainArgs].
 */
@PulumiTagMarker
public class GetSqlServerInstancePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var sqlServerInstanceName: String? = null

    /**
     * @param value The name of the Azure resource group
     */
    @JvmName("hoxlogsaaqejhqep")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of SQL Server Instance
     */
    @JvmName("nivufngqfpdvmlru")
    public suspend fun sqlServerInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlServerInstanceName = mapped
    }

    internal fun build(): GetSqlServerInstancePlainArgs = GetSqlServerInstancePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sqlServerInstanceName = sqlServerInstanceName ?: throw
            PulumiNullFieldException("sqlServerInstanceName"),
    )
}
