@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.K8sNetworkSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The kubernetes network settings information.
 * @property forceencryption If 1, then SQL Server forces all connections to be encrypted. By default, this option is 0
 * @property tlsciphers Specifies which ciphers are allowed by SQL Server for TLS
 * @property tlsprotocols A comma-separated list of which TLS protocols are allowed by SQL Server
 */
public data class K8sNetworkSettingsArgs(
    public val forceencryption: Output<Int>? = null,
    public val tlsciphers: Output<String>? = null,
    public val tlsprotocols: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.K8sNetworkSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.K8sNetworkSettingsArgs =
        com.pulumi.azurenative.azurearcdata.inputs.K8sNetworkSettingsArgs.builder()
            .forceencryption(forceencryption?.applyValue({ args0 -> args0 }))
            .tlsciphers(tlsciphers?.applyValue({ args0 -> args0 }))
            .tlsprotocols(tlsprotocols?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [K8sNetworkSettingsArgs].
 */
@PulumiTagMarker
public class K8sNetworkSettingsArgsBuilder internal constructor() {
    private var forceencryption: Output<Int>? = null

    private var tlsciphers: Output<String>? = null

    private var tlsprotocols: Output<String>? = null

    /**
     * @param value If 1, then SQL Server forces all connections to be encrypted. By default, this option is 0
     */
    @JvmName("oefoibvlccgrgdyf")
    public suspend fun forceencryption(`value`: Output<Int>) {
        this.forceencryption = value
    }

    /**
     * @param value Specifies which ciphers are allowed by SQL Server for TLS
     */
    @JvmName("wflubcnqtkoxxjbx")
    public suspend fun tlsciphers(`value`: Output<String>) {
        this.tlsciphers = value
    }

    /**
     * @param value A comma-separated list of which TLS protocols are allowed by SQL Server
     */
    @JvmName("xojrdcibovkairvm")
    public suspend fun tlsprotocols(`value`: Output<String>) {
        this.tlsprotocols = value
    }

    /**
     * @param value If 1, then SQL Server forces all connections to be encrypted. By default, this option is 0
     */
    @JvmName("ucuoltnihltgskaj")
    public suspend fun forceencryption(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceencryption = mapped
    }

    /**
     * @param value Specifies which ciphers are allowed by SQL Server for TLS
     */
    @JvmName("ctdgaqsdtgxerchm")
    public suspend fun tlsciphers(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsciphers = mapped
    }

    /**
     * @param value A comma-separated list of which TLS protocols are allowed by SQL Server
     */
    @JvmName("hrplxntmukqhbfxx")
    public suspend fun tlsprotocols(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tlsprotocols = mapped
    }

    internal fun build(): K8sNetworkSettingsArgs = K8sNetworkSettingsArgs(
        forceencryption = forceencryption,
        tlsciphers = tlsciphers,
        tlsprotocols = tlsprotocols,
    )
}
