@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.K8sSchedulingOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service
 * @property resources The kubernetes resource limits and requests used to restrict or reserve resource usage.
 */
public data class K8sSchedulingOptionsArgs(
    public val resources: Output<K8sResourceRequirementsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.K8sSchedulingOptionsArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.K8sSchedulingOptionsArgs =
        com.pulumi.azurenative.azurearcdata.inputs.K8sSchedulingOptionsArgs.builder()
            .resources(resources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [K8sSchedulingOptionsArgs].
 */
@PulumiTagMarker
public class K8sSchedulingOptionsArgsBuilder internal constructor() {
    private var resources: Output<K8sResourceRequirementsArgs>? = null

    /**
     * @param value The kubernetes resource limits and requests used to restrict or reserve resource usage.
     */
    @JvmName("gnjlxpjdmxrwdepo")
    public suspend fun resources(`value`: Output<K8sResourceRequirementsArgs>) {
        this.resources = value
    }

    /**
     * @param value The kubernetes resource limits and requests used to restrict or reserve resource usage.
     */
    @JvmName("tgegejcvorspayyi")
    public suspend fun resources(`value`: K8sResourceRequirementsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument The kubernetes resource limits and requests used to restrict or reserve resource usage.
     */
    @JvmName("ssnljynttcacjnqx")
    public suspend fun resources(argument: suspend K8sResourceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped = K8sResourceRequirementsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    internal fun build(): K8sSchedulingOptionsArgs = K8sSchedulingOptionsArgs(
        resources = resources,
    )
}
