@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.K8stransparentDataEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Transparent data encryption information.
 * @property mode Transparent data encryption mode. Can be Service Managed, Customer managed or disabled
 * @property protectorSecret Protector secret for customer managed Transparent data encryption mode
 */
public data class K8stransparentDataEncryptionArgs(
    public val mode: Output<String>? = null,
    public val protectorSecret: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.K8stransparentDataEncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.K8stransparentDataEncryptionArgs =
        com.pulumi.azurenative.azurearcdata.inputs.K8stransparentDataEncryptionArgs.builder()
            .mode(mode?.applyValue({ args0 -> args0 }))
            .protectorSecret(protectorSecret?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [K8stransparentDataEncryptionArgs].
 */
@PulumiTagMarker
public class K8stransparentDataEncryptionArgsBuilder internal constructor() {
    private var mode: Output<String>? = null

    private var protectorSecret: Output<String>? = null

    /**
     * @param value Transparent data encryption mode. Can be Service Managed, Customer managed or disabled
     */
    @JvmName("kjtrgqqogwmoimav")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value Protector secret for customer managed Transparent data encryption mode
     */
    @JvmName("txrahvmshfxhoobo")
    public suspend fun protectorSecret(`value`: Output<String>) {
        this.protectorSecret = value
    }

    /**
     * @param value Transparent data encryption mode. Can be Service Managed, Customer managed or disabled
     */
    @JvmName("jmyatypspncqwwdu")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Protector secret for customer managed Transparent data encryption mode
     */
    @JvmName("oweqddgpphdvmumx")
    public suspend fun protectorSecret(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectorSecret = mapped
    }

    internal fun build(): K8stransparentDataEncryptionArgs = K8stransparentDataEncryptionArgs(
        mode = mode,
        protectorSecret = protectorSecret,
    )
}
