@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.inputs

import com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstanceSkuArgs.builder
import com.pulumi.azurenative.azurearcdata.kotlin.enums.SqlManagedInstanceSkuName
import com.pulumi.azurenative.azurearcdata.kotlin.enums.SqlManagedInstanceSkuTier
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The resource model definition representing SKU for Azure Managed Instance - Azure Arc
 * @property capacity The SKU capacity
 * @property dev Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose.
 * @property family The SKU family
 * @property name The name of the SKU.
 * @property size The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
 * @property tier The pricing tier for the instance.
 */
public data class SqlManagedInstanceSkuArgs(
    public val capacity: Output<Int>? = null,
    public val dev: Output<Boolean>? = null,
    public val family: Output<String>? = null,
    public val name: Output<SqlManagedInstanceSkuName>,
    public val size: Output<String>? = null,
    public val tier: Output<SqlManagedInstanceSkuTier>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstanceSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstanceSkuArgs =
        com.pulumi.azurenative.azurearcdata.inputs.SqlManagedInstanceSkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .dev(dev?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .size(size?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [SqlManagedInstanceSkuArgs].
 */
@PulumiTagMarker
public class SqlManagedInstanceSkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var dev: Output<Boolean>? = null

    private var family: Output<String>? = null

    private var name: Output<SqlManagedInstanceSkuName>? = null

    private var size: Output<String>? = null

    private var tier: Output<SqlManagedInstanceSkuTier>? = null

    /**
     * @param value The SKU capacity
     */
    @JvmName("wntxoggwcbgiterj")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose.
     */
    @JvmName("rbcftucllvemwxro")
    public suspend fun dev(`value`: Output<Boolean>) {
        this.dev = value
    }

    /**
     * @param value The SKU family
     */
    @JvmName("wjvfcyaqxnytsqtw")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("gyokasdepuaakhir")
    public suspend fun name(`value`: Output<SqlManagedInstanceSkuName>) {
        this.name = value
    }

    /**
     * @param value The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
     */
    @JvmName("mgphbhudqpuwbptb")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value The pricing tier for the instance.
     */
    @JvmName("noqcqxqnuuuolbvf")
    public suspend fun tier(`value`: Output<SqlManagedInstanceSkuTier>) {
        this.tier = value
    }

    /**
     * @param value The SKU capacity
     */
    @JvmName("kwbpnkubogfwagah")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Whether dev/test is enabled. When the dev field is set to true, the resource is used for dev/test purpose.
     */
    @JvmName("wygfjxmahkkydlpk")
    public suspend fun dev(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dev = mapped
    }

    /**
     * @param value The SKU family
     */
    @JvmName("fwksommpmiujimgk")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("nfiacmukqoyheufh")
    public suspend fun name(`value`: SqlManagedInstanceSkuName) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code.
     */
    @JvmName("xeaxjhtamexmmsyk")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The pricing tier for the instance.
     */
    @JvmName("cnaxhdehvimispnm")
    public suspend fun tier(`value`: SqlManagedInstanceSkuTier?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SqlManagedInstanceSkuArgs = SqlManagedInstanceSkuArgs(
        capacity = capacity,
        dev = dev,
        family = family,
        name = name ?: throw PulumiNullFieldException("name"),
        size = size,
        tier = tier,
    )
}
