@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The kubernetes resource limits and requests used to restrict or reserve resource usage.
 * @property limits Limits for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default 'memory' is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum 'memory' is '128Gi'.
 * @property requests Requests for a kubernetes resource type (e.g 'cpu', 'memory'). The 'cpu' request must be less than or equal to 'cpu' limit. Default 'cpu' is 2, minimum is 1. Default 'memory' is '4Gi', minimum is '2Gi. If sku.tier is GeneralPurpose, maximum 'cpu' is 24 and maximum 'memory' is '128Gi'.
 */
public data class K8sResourceRequirementsResponse(
    public val limits: Map<String, String>? = null,
    public val requests: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.K8sResourceRequirementsResponse):
            K8sResourceRequirementsResponse = K8sResourceRequirementsResponse(
            limits = javaType.limits().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            requests = javaType.requests().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
