@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.Suppress

/**
 * The kubernetes scheduling options. It describes restrictions used to help Kubernetes select appropriate nodes to host the database service
 * @property resources The kubernetes resource limits and requests used to restrict or reserve resource usage.
 */
public data class K8sSchedulingOptionsResponse(
    public val resources: K8sResourceRequirementsResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.K8sSchedulingOptionsResponse):
            K8sSchedulingOptionsResponse = K8sSchedulingOptionsResponse(
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.azurearcdata.kotlin.outputs.K8sResourceRequirementsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
