@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurearcdata.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties from the Kubernetes data controller
 * @property id A globally unique ID identifying the associated Kubernetes cluster
 * @property publicSigningKey Certificate that contains the Kubernetes cluster public key used to verify signing
 * @property signingCertificateThumbprint Unique thumbprint returned to customer to verify the certificate being uploaded
 */
public data class OnPremisePropertyResponse(
    public val id: String,
    public val publicSigningKey: String,
    public val signingCertificateThumbprint: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.azurearcdata.outputs.OnPremisePropertyResponse):
            OnPremisePropertyResponse = OnPremisePropertyResponse(
            id = javaType.id(),
            publicSigningKey = javaType.publicSigningKey(),
            signingCertificateThumbprint = javaType.signingCertificateThumbprint().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
