@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuredata.kotlin.inputs

import com.pulumi.azurenative.azuredata.inputs.GetSqlServerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The child resources to include in the response.
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property sqlServerName Name of the SQL Server.
 * @property sqlServerRegistrationName Name of the SQL Server registration.
 */
public data class GetSqlServerPlainArgs(
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val sqlServerName: String,
    public val sqlServerRegistrationName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azuredata.inputs.GetSqlServerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azuredata.inputs.GetSqlServerPlainArgs =
        com.pulumi.azurenative.azuredata.inputs.GetSqlServerPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sqlServerName(sqlServerName.let({ args0 -> args0 }))
            .sqlServerRegistrationName(sqlServerRegistrationName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlServerPlainArgs].
 */
@PulumiTagMarker
public class GetSqlServerPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var sqlServerName: String? = null

    private var sqlServerRegistrationName: String? = null

    /**
     * @param value The child resources to include in the response.
     */
    @JvmName("myihajauqtjqaubl")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("sxnhnysjvcrovief")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the SQL Server.
     */
    @JvmName("ugkxlqkcroxvljdd")
    public suspend fun sqlServerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlServerName = mapped
    }

    /**
     * @param value Name of the SQL Server registration.
     */
    @JvmName("ctdmxknxkelkdadd")
    public suspend fun sqlServerRegistrationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlServerRegistrationName = mapped
    }

    internal fun build(): GetSqlServerPlainArgs = GetSqlServerPlainArgs(
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sqlServerName = sqlServerName ?: throw PulumiNullFieldException("sqlServerName"),
        sqlServerRegistrationName = sqlServerRegistrationName ?: throw
            PulumiNullFieldException("sqlServerRegistrationName"),
    )
}
