@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin

import com.pulumi.azurenative.azuresphere.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.azuresphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Device].
 */
@PulumiTagMarker
public class DeviceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeviceArgs = DeviceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeviceArgsBuilder.() -> Unit) {
        val builder = DeviceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Device {
        val builtJavaResource = com.pulumi.azurenative.azuresphere.Device(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Device(builtJavaResource)
    }
}

/**
 * An device resource belonging to a device group resource.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * ## Example Usage
 * ### Devices_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var device = new AzureNative.AzureSphere.Device("device", new()
 *     {
 *         CatalogName = "MyCatalog1",
 *         DeviceGroupName = "myDeviceGroup1",
 *         DeviceName = "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
 *         ProductName = "MyProduct1",
 *         ResourceGroupName = "MyResourceGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuresphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuresphere.NewDevice(ctx, "device", &azuresphere.DeviceArgs{
 * 			CatalogName:       pulumi.String("MyCatalog1"),
 * 			DeviceGroupName:   pulumi.String("myDeviceGroup1"),
 * 			DeviceName:        pulumi.String("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"),
 * 			ProductName:       pulumi.String("MyProduct1"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuresphere.Device;
 * import com.pulumi.azurenative.azuresphere.DeviceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var device = new Device("device", DeviceArgs.builder()
 *             .catalogName("MyCatalog1")
 *             .deviceGroupName("myDeviceGroup1")
 *             .deviceName("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000")
 *             .productName("MyProduct1")
 *             .resourceGroupName("MyResourceGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuresphere:Device 00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/products/{productName}/deviceGroups/{deviceGroupName}/devices/{deviceName}
 * ```
 */
public class Device internal constructor(
    override val javaResource: com.pulumi.azurenative.azuresphere.Device,
) : KotlinCustomResource(javaResource, DeviceMapper) {
    /**
     * SKU of the chip
     */
    public val chipSku: Output<String>
        get() = javaResource.chipSku().applyValue({ args0 -> args0 })

    /**
     * Device ID
     */
    public val deviceId: Output<String>?
        get() = javaResource.deviceId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * OS version available for installation when update requested
     */
    public val lastAvailableOsVersion: Output<String>
        get() = javaResource.lastAvailableOsVersion().applyValue({ args0 -> args0 })

    /**
     * OS version running on device when update requested
     */
    public val lastInstalledOsVersion: Output<String>
        get() = javaResource.lastInstalledOsVersion().applyValue({ args0 -> args0 })

    /**
     * Time when update requested and new OS version available
     */
    public val lastOsUpdateUtc: Output<String>
        get() = javaResource.lastOsUpdateUtc().applyValue({ args0 -> args0 })

    /**
     * Time when update was last requested
     */
    public val lastUpdateRequestUtc: Output<String>
        get() = javaResource.lastUpdateRequestUtc().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DeviceMapper : ResourceMapper<Device> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azuresphere.Device::class == javaResource::class

    override fun map(javaResource: Resource): Device = Device(
        javaResource as
            com.pulumi.azurenative.azuresphere.Device,
    )
}

/**
 * @see [Device].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Device].
 */
public suspend fun device(name: String, block: suspend DeviceResourceBuilder.() -> Unit): Device {
    val builder = DeviceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Device].
 * @param name The _unique_ name of the resulting resource.
 */
public fun device(name: String): Device {
    val builder = DeviceResourceBuilder()
    builder.name(name)
    return builder.build()
}
