@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin

import com.pulumi.azurenative.azuresphere.DeviceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An device resource belonging to a device group resource.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * ## Example Usage
 * ### Devices_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var device = new AzureNative.AzureSphere.Device("device", new()
 *     {
 *         CatalogName = "MyCatalog1",
 *         DeviceGroupName = "myDeviceGroup1",
 *         DeviceName = "00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000",
 *         ProductName = "MyProduct1",
 *         ResourceGroupName = "MyResourceGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuresphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuresphere.NewDevice(ctx, "device", &azuresphere.DeviceArgs{
 * 			CatalogName:       pulumi.String("MyCatalog1"),
 * 			DeviceGroupName:   pulumi.String("myDeviceGroup1"),
 * 			DeviceName:        pulumi.String("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"),
 * 			ProductName:       pulumi.String("MyProduct1"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuresphere.Device;
 * import com.pulumi.azurenative.azuresphere.DeviceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var device = new Device("device", DeviceArgs.builder()
 *             .catalogName("MyCatalog1")
 *             .deviceGroupName("myDeviceGroup1")
 *             .deviceName("00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000")
 *             .productName("MyProduct1")
 *             .resourceGroupName("MyResourceGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuresphere:Device 00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/products/{productName}/deviceGroups/{deviceGroupName}/devices/{deviceName}
 * ```
 * @property catalogName Name of catalog
 * @property deviceGroupName Name of device group.
 * @property deviceId Device ID
 * @property deviceName Device name
 * @property productName Name of product.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class DeviceArgs(
    public val catalogName: Output<String>? = null,
    public val deviceGroupName: Output<String>? = null,
    public val deviceId: Output<String>? = null,
    public val deviceName: Output<String>? = null,
    public val productName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuresphere.DeviceArgs> {
    override fun toJava(): com.pulumi.azurenative.azuresphere.DeviceArgs =
        com.pulumi.azurenative.azuresphere.DeviceArgs.builder()
            .catalogName(catalogName?.applyValue({ args0 -> args0 }))
            .deviceGroupName(deviceGroupName?.applyValue({ args0 -> args0 }))
            .deviceId(deviceId?.applyValue({ args0 -> args0 }))
            .deviceName(deviceName?.applyValue({ args0 -> args0 }))
            .productName(productName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeviceArgs].
 */
@PulumiTagMarker
public class DeviceArgsBuilder internal constructor() {
    private var catalogName: Output<String>? = null

    private var deviceGroupName: Output<String>? = null

    private var deviceId: Output<String>? = null

    private var deviceName: Output<String>? = null

    private var productName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of catalog
     */
    @JvmName("wssgoyoujvxvsxmo")
    public suspend fun catalogName(`value`: Output<String>) {
        this.catalogName = value
    }

    /**
     * @param value Name of device group.
     */
    @JvmName("bkngrpdletclpkav")
    public suspend fun deviceGroupName(`value`: Output<String>) {
        this.deviceGroupName = value
    }

    /**
     * @param value Device ID
     */
    @JvmName("wxxagsumvjnrgysk")
    public suspend fun deviceId(`value`: Output<String>) {
        this.deviceId = value
    }

    /**
     * @param value Device name
     */
    @JvmName("yywjgavqrtmovgxm")
    public suspend fun deviceName(`value`: Output<String>) {
        this.deviceName = value
    }

    /**
     * @param value Name of product.
     */
    @JvmName("bvqpbywdpncbygvq")
    public suspend fun productName(`value`: Output<String>) {
        this.productName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eeeqivmgmuxcswfs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of catalog
     */
    @JvmName("tdjbnxwhvyqhaojt")
    public suspend fun catalogName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogName = mapped
    }

    /**
     * @param value Name of device group.
     */
    @JvmName("jicnesqawuohcwqy")
    public suspend fun deviceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceGroupName = mapped
    }

    /**
     * @param value Device ID
     */
    @JvmName("gwuyfdhgsgbmekrl")
    public suspend fun deviceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceId = mapped
    }

    /**
     * @param value Device name
     */
    @JvmName("raevwgrbiaqfwucy")
    public suspend fun deviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceName = mapped
    }

    /**
     * @param value Name of product.
     */
    @JvmName("xrrtpffkhebnxseg")
    public suspend fun productName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qwvnnynsmcecafre")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): DeviceArgs = DeviceArgs(
        catalogName = catalogName,
        deviceGroupName = deviceGroupName,
        deviceId = deviceId,
        deviceName = deviceName,
        productName = productName,
        resourceGroupName = resourceGroupName,
    )
}
