@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin

import com.pulumi.azurenative.azuresphere.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.azuresphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Product].
 */
@PulumiTagMarker
public class ProductResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ProductArgs = ProductArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ProductArgsBuilder.() -> Unit) {
        val builder = ProductArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Product {
        val builtJavaResource = com.pulumi.azurenative.azuresphere.Product(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Product(builtJavaResource)
    }
}

/**
 * An product resource belonging to a catalog resource.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * ## Example Usage
 * ### Products_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var product = new AzureNative.AzureSphere.Product("product", new()
 *     {
 *         CatalogName = "MyCatalog1",
 *         ProductName = "MyProduct1",
 *         ResourceGroupName = "MyResourceGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuresphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuresphere.NewProduct(ctx, "product", &azuresphere.ProductArgs{
 * 			CatalogName:       pulumi.String("MyCatalog1"),
 * 			ProductName:       pulumi.String("MyProduct1"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuresphere.Product;
 * import com.pulumi.azurenative.azuresphere.ProductArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var product = new Product("product", ProductArgs.builder()
 *             .catalogName("MyCatalog1")
 *             .productName("MyProduct1")
 *             .resourceGroupName("MyResourceGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuresphere:Product MyProduct1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/products/{productName}
 * ```
 */
public class Product internal constructor(
    override val javaResource: com.pulumi.azurenative.azuresphere.Product,
) : KotlinCustomResource(javaResource, ProductMapper) {
    /**
     * Description of the product
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ProductMapper : ResourceMapper<Product> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azuresphere.Product::class == javaResource::class

    override fun map(javaResource: Resource): Product = Product(
        javaResource as
            com.pulumi.azurenative.azuresphere.Product,
    )
}

/**
 * @see [Product].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Product].
 */
public suspend fun product(name: String, block: suspend ProductResourceBuilder.() -> Unit):
    Product {
    val builder = ProductResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Product].
 * @param name The _unique_ name of the resulting resource.
 */
public fun product(name: String): Product {
    val builder = ProductResourceBuilder()
    builder.name(name)
    return builder.build()
}
