@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin

import com.pulumi.azurenative.azuresphere.ProductArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An product resource belonging to a catalog resource.
 * Azure REST API version: 2022-09-01-preview. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * ## Example Usage
 * ### Products_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var product = new AzureNative.AzureSphere.Product("product", new()
 *     {
 *         CatalogName = "MyCatalog1",
 *         ProductName = "MyProduct1",
 *         ResourceGroupName = "MyResourceGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azuresphere/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azuresphere.NewProduct(ctx, "product", &azuresphere.ProductArgs{
 * 			CatalogName:       pulumi.String("MyCatalog1"),
 * 			ProductName:       pulumi.String("MyProduct1"),
 * 			ResourceGroupName: pulumi.String("MyResourceGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azuresphere.Product;
 * import com.pulumi.azurenative.azuresphere.ProductArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var product = new Product("product", ProductArgs.builder()
 *             .catalogName("MyCatalog1")
 *             .productName("MyProduct1")
 *             .resourceGroupName("MyResourceGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azuresphere:Product MyProduct1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureSphere/catalogs/{catalogName}/products/{productName}
 * ```
 * @property catalogName Name of catalog
 * @property description Description of the product
 * @property productName Name of product.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class ProductArgs(
    public val catalogName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val productName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azuresphere.ProductArgs> {
    override fun toJava(): com.pulumi.azurenative.azuresphere.ProductArgs =
        com.pulumi.azurenative.azuresphere.ProductArgs.builder()
            .catalogName(catalogName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .productName(productName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ProductArgs].
 */
@PulumiTagMarker
public class ProductArgsBuilder internal constructor() {
    private var catalogName: Output<String>? = null

    private var description: Output<String>? = null

    private var productName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of catalog
     */
    @JvmName("dubjdddsxoklttfd")
    public suspend fun catalogName(`value`: Output<String>) {
        this.catalogName = value
    }

    /**
     * @param value Description of the product
     */
    @JvmName("wolybmvyhkwgkway")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Name of product.
     */
    @JvmName("nmelxwwqwvwlmoij")
    public suspend fun productName(`value`: Output<String>) {
        this.productName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fgemhikuoripimgr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of catalog
     */
    @JvmName("nsiqgiwnjxrlcedy")
    public suspend fun catalogName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogName = mapped
    }

    /**
     * @param value Description of the product
     */
    @JvmName("hgkrsggwoqsufybx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Name of product.
     */
    @JvmName("fcfveoupiiqebymn")
    public suspend fun productName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.productName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("svvehnetjajalkfu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): ProductArgs = ProductArgs(
        catalogName = catalogName,
        description = description,
        productName = productName,
        resourceGroupName = resourceGroupName,
    )
}
