@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.inputs

import com.pulumi.azurenative.azuresphere.inputs.GetCatalogPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogName Name of catalog
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetCatalogPlainArgs(
    public val catalogName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.azuresphere.inputs.GetCatalogPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azuresphere.inputs.GetCatalogPlainArgs =
        com.pulumi.azurenative.azuresphere.inputs.GetCatalogPlainArgs.builder()
            .catalogName(catalogName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetCatalogPlainArgs].
 */
@PulumiTagMarker
public class GetCatalogPlainArgsBuilder internal constructor() {
    private var catalogName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of catalog
     */
    @JvmName("xopgqcwnfhufjaqt")
    public suspend fun catalogName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jpgobibssotsxscm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetCatalogPlainArgs = GetCatalogPlainArgs(
        catalogName = catalogName ?: throw PulumiNullFieldException("catalogName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
