@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azuresphere.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An product resource belonging to a catalog resource.
 * @property description Description of the product
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetProductResult(
    public val description: String,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azuresphere.outputs.GetProductResult):
            GetProductResult = GetProductResult(
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.azuresphere.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
