@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [CustomerSubscription].
 */
@PulumiTagMarker
public class CustomerSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomerSubscriptionArgs = CustomerSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomerSubscriptionArgsBuilder.() -> Unit) {
        val builder = CustomerSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): CustomerSubscription {
        val builtJavaResource =
            com.pulumi.azurenative.azurestack.CustomerSubscription(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CustomerSubscription(builtJavaResource)
    }
}

/**
 * Customer subscription.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2017-06-01.
 * Other available API versions: 2020-06-01-preview.
 * ## Example Usage
 * ### Creates a new customer subscription under a registration.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var customerSubscription = new AzureNative.AzureStack.CustomerSubscription("customerSubscription", new()
 *     {
 *         CustomerSubscriptionName = "E09A4E93-29A7-4EBA-A6D4-76202383F07F",
 *         RegistrationName = "testregistration",
 *         ResourceGroup = "azurestack",
 *         TenantId = "dbab3982-796f-4d03-9908-044c08aef8a2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestack/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestack.NewCustomerSubscription(ctx, "customerSubscription", &azurestack.CustomerSubscriptionArgs{
 * 			CustomerSubscriptionName: pulumi.String("E09A4E93-29A7-4EBA-A6D4-76202383F07F"),
 * 			RegistrationName:         pulumi.String("testregistration"),
 * 			ResourceGroup:            pulumi.String("azurestack"),
 * 			TenantId:                 pulumi.String("dbab3982-796f-4d03-9908-044c08aef8a2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestack.CustomerSubscription;
 * import com.pulumi.azurenative.azurestack.CustomerSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var customerSubscription = new CustomerSubscription("customerSubscription", CustomerSubscriptionArgs.builder()
 *             .customerSubscriptionName("E09A4E93-29A7-4EBA-A6D4-76202383F07F")
 *             .registrationName("testregistration")
 *             .resourceGroup("azurestack")
 *             .tenantId("dbab3982-796f-4d03-9908-044c08aef8a2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestack:CustomerSubscription myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.AzureStack/registrations/{registrationName}/customerSubscriptions/{customerSubscriptionName}
 * ```
 */
public class CustomerSubscription internal constructor(
    override val javaResource: com.pulumi.azurenative.azurestack.CustomerSubscription,
) : KotlinCustomResource(javaResource, CustomerSubscriptionMapper) {
    /**
     * The entity tag used for optimistic concurrency when modifying the resource.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Tenant Id.
     */
    public val tenantId: Output<String>?
        get() = javaResource.tenantId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Type of Resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CustomerSubscriptionMapper : ResourceMapper<CustomerSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurestack.CustomerSubscription::class == javaResource::class

    override fun map(javaResource: Resource): CustomerSubscription = CustomerSubscription(
        javaResource
            as com.pulumi.azurenative.azurestack.CustomerSubscription,
    )
}

/**
 * @see [CustomerSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomerSubscription].
 */
public suspend fun customerSubscription(
    name: String,
    block: suspend CustomerSubscriptionResourceBuilder.() -> Unit,
): CustomerSubscription {
    val builder = CustomerSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomerSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customerSubscription(name: String): CustomerSubscription {
    val builder = CustomerSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
