@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin

import com.pulumi.azurenative.azurestack.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.azurestack.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [LinkedSubscription].
 */
@PulumiTagMarker
public class LinkedSubscriptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LinkedSubscriptionArgs = LinkedSubscriptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LinkedSubscriptionArgsBuilder.() -> Unit) {
        val builder = LinkedSubscriptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): LinkedSubscription {
        val builtJavaResource =
            com.pulumi.azurenative.azurestack.LinkedSubscription(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return LinkedSubscription(builtJavaResource)
    }
}

/**
 * Linked Subscription information.
 * Azure REST API version: 2020-06-01-preview. Prior API version in Azure Native 1.x: 2020-06-01-preview.
 * ## Example Usage
 * ### Create or update a Linked Subscription.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var linkedSubscription = new AzureNative.AzureStack.LinkedSubscription("linkedSubscription", new()
 *     {
 *         LinkedSubscriptionId = "104fbb77-2b0e-476a-83de-65ad8acd1f0b",
 *         LinkedSubscriptionName = "testLinkedSubscription",
 *         Location = "eastus",
 *         RegistrationResourceId = "/subscriptions/dd8597b4-8739-4467-8b10-f8679f62bfbf/resourceGroups/azurestack/providers/Microsoft.AzureStack/registrations/testRegistration",
 *         ResourceGroup = "azurestack",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestack/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestack.NewLinkedSubscription(ctx, "linkedSubscription", &azurestack.LinkedSubscriptionArgs{
 * 			LinkedSubscriptionId:   pulumi.String("104fbb77-2b0e-476a-83de-65ad8acd1f0b"),
 * 			LinkedSubscriptionName: pulumi.String("testLinkedSubscription"),
 * 			Location:               pulumi.String("eastus"),
 * 			RegistrationResourceId: pulumi.String("/subscriptions/dd8597b4-8739-4467-8b10-f8679f62bfbf/resourceGroups/azurestack/providers/Microsoft.AzureStack/registrations/testRegistration"),
 * 			ResourceGroup:          pulumi.String("azurestack"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestack.LinkedSubscription;
 * import com.pulumi.azurenative.azurestack.LinkedSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var linkedSubscription = new LinkedSubscription("linkedSubscription", LinkedSubscriptionArgs.builder()
 *             .linkedSubscriptionId("104fbb77-2b0e-476a-83de-65ad8acd1f0b")
 *             .linkedSubscriptionName("testLinkedSubscription")
 *             .location("eastus")
 *             .registrationResourceId("/subscriptions/dd8597b4-8739-4467-8b10-f8679f62bfbf/resourceGroups/azurestack/providers/Microsoft.AzureStack/registrations/testRegistration")
 *             .resourceGroup("azurestack")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestack:LinkedSubscription testLinkedSubscription /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.AzureStack/linkedSubscriptions/{linkedSubscriptionName}
 * ```
 */
public class LinkedSubscription internal constructor(
    override val javaResource: com.pulumi.azurenative.azurestack.LinkedSubscription,
) : KotlinCustomResource(javaResource, LinkedSubscriptionMapper) {
    /**
     * The status of the remote management connection of the Azure Stack device.
     */
    public val deviceConnectionStatus: Output<String>
        get() = javaResource.deviceConnectionStatus().applyValue({ args0 -> args0 })

    /**
     * The identifier of the Azure Stack device for remote management.
     */
    public val deviceId: Output<String>
        get() = javaResource.deviceId().applyValue({ args0 -> args0 })

    /**
     * The connection state of the Azure Stack device.
     */
    public val deviceLinkState: Output<String>
        get() = javaResource.deviceLinkState().applyValue({ args0 -> args0 })

    /**
     * The object identifier associated with the Azure Stack device connecting to Azure.
     */
    public val deviceObjectId: Output<String>
        get() = javaResource.deviceObjectId().applyValue({ args0 -> args0 })

    /**
     * The entity tag used for optimistic concurrency when modifying the resource.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The kind of the resource.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The last remote management connection time for the Azure Stack device connected to the linked subscription resource.
     */
    public val lastConnectedTime: Output<String>
        get() = javaResource.lastConnectedTime().applyValue({ args0 -> args0 })

    /**
     * The identifier associated with the device subscription.
     */
    public val linkedSubscriptionId: Output<String>?
        get() = javaResource.linkedSubscriptionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Location of the resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The identifier associated with the device registration.
     */
    public val registrationResourceId: Output<String>?
        get() = javaResource.registrationResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Custom tags for the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Type of Resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object LinkedSubscriptionMapper : ResourceMapper<LinkedSubscription> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurestack.LinkedSubscription::class == javaResource::class

    override fun map(javaResource: Resource): LinkedSubscription = LinkedSubscription(
        javaResource as
            com.pulumi.azurenative.azurestack.LinkedSubscription,
    )
}

/**
 * @see [LinkedSubscription].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [LinkedSubscription].
 */
public suspend fun linkedSubscription(
    name: String,
    block: suspend LinkedSubscriptionResourceBuilder.() -> Unit,
): LinkedSubscription {
    val builder = LinkedSubscriptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [LinkedSubscription].
 * @param name The _unique_ name of the resulting resource.
 */
public fun linkedSubscription(name: String): LinkedSubscription {
    val builder = LinkedSubscriptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
