@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin.inputs

import com.pulumi.azurenative.azurestack.inputs.GetRegistrationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property registrationName Name of the Azure Stack registration.
 * @property resourceGroup Name of the resource group.
 */
public data class GetRegistrationPlainArgs(
    public val registrationName: String,
    public val resourceGroup: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestack.inputs.GetRegistrationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestack.inputs.GetRegistrationPlainArgs =
        com.pulumi.azurenative.azurestack.inputs.GetRegistrationPlainArgs.builder()
            .registrationName(registrationName.let({ args0 -> args0 }))
            .resourceGroup(resourceGroup.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRegistrationPlainArgs].
 */
@PulumiTagMarker
public class GetRegistrationPlainArgsBuilder internal constructor() {
    private var registrationName: String? = null

    private var resourceGroup: String? = null

    /**
     * @param value Name of the Azure Stack registration.
     */
    @JvmName("qwhdabcipfqecgxt")
    public suspend fun registrationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registrationName = mapped
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("npdvvkeobwcidplk")
    public suspend fun resourceGroup(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroup = mapped
    }

    internal fun build(): GetRegistrationPlainArgs = GetRegistrationPlainArgs(
        registrationName = registrationName ?: throw PulumiNullFieldException("registrationName"),
        resourceGroup = resourceGroup ?: throw PulumiNullFieldException("resourceGroup"),
    )
}
