@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin.inputs

import com.pulumi.azurenative.azurestack.inputs.ListProductsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property productName Name of the product.
 * @property registrationName Name of the Azure Stack registration.
 * @property resourceGroup Name of the resource group.
 */
public data class ListProductsPlainArgs(
    public val productName: String,
    public val registrationName: String,
    public val resourceGroup: String,
) : ConvertibleToJava<com.pulumi.azurenative.azurestack.inputs.ListProductsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestack.inputs.ListProductsPlainArgs =
        com.pulumi.azurenative.azurestack.inputs.ListProductsPlainArgs.builder()
            .productName(productName.let({ args0 -> args0 }))
            .registrationName(registrationName.let({ args0 -> args0 }))
            .resourceGroup(resourceGroup.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListProductsPlainArgs].
 */
@PulumiTagMarker
public class ListProductsPlainArgsBuilder internal constructor() {
    private var productName: String? = null

    private var registrationName: String? = null

    private var resourceGroup: String? = null

    /**
     * @param value Name of the product.
     */
    @JvmName("vavjkmdqoywvmyir")
    public suspend fun productName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.productName = mapped
    }

    /**
     * @param value Name of the Azure Stack registration.
     */
    @JvmName("txtptkgnpieyddjm")
    public suspend fun registrationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.registrationName = mapped
    }

    /**
     * @param value Name of the resource group.
     */
    @JvmName("kltclbxpghhvtynb")
    public suspend fun resourceGroup(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroup = mapped
    }

    internal fun build(): ListProductsPlainArgs = ListProductsPlainArgs(
        productName = productName ?: throw PulumiNullFieldException("productName"),
        registrationName = registrationName ?: throw PulumiNullFieldException("registrationName"),
        resourceGroup = resourceGroup ?: throw PulumiNullFieldException("resourceGroup"),
    )
}
