@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestack.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Data disk image.
 * @property lun The LUN.
 * @property sourceBlobSasUri SAS key for source blob.
 */
public data class DataDiskImageResponse(
    public val lun: Int,
    public val sourceBlobSasUri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestack.outputs.DataDiskImageResponse):
            DataDiskImageResponse = DataDiskImageResponse(
            lun = javaType.lun(),
            sourceBlobSasUri = javaType.sourceBlobSasUri(),
        )
    }
}
