@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ArcConnectivityPropertiesResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.DefaultExtensionDetailsResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.PerNodeStateResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.ArcConnectivityPropertiesResponse.Companion.toKotlin as arcConnectivityPropertiesResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.DefaultExtensionDetailsResponse.Companion.toKotlin as defaultExtensionDetailsResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.PerNodeStateResponse.Companion.toKotlin as perNodeStateResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ArcSetting].
 */
@PulumiTagMarker
public class ArcSettingResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ArcSettingArgs = ArcSettingArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ArcSettingArgsBuilder.() -> Unit) {
        val builder = ArcSettingArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ArcSetting {
        val builtJavaResource = com.pulumi.azurenative.azurestackhci.ArcSetting(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ArcSetting(builtJavaResource)
    }
}

/**
 * ArcSetting details.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-01-01-preview.
 * Other available API versions: 2021-09-01-preview, 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview.
 * ## Example Usage
 * ### Create ArcSetting
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var arcSetting = new AzureNative.AzureStackHCI.ArcSetting("arcSetting", new()
 *     {
 *         ArcSettingName = "default",
 *         ClusterName = "myCluster",
 *         ResourceGroupName = "test-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewArcSetting(ctx, "arcSetting", &azurestackhci.ArcSettingArgs{
 * 			ArcSettingName:    pulumi.String("default"),
 * 			ClusterName:       pulumi.String("myCluster"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.ArcSetting;
 * import com.pulumi.azurenative.azurestackhci.ArcSettingArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var arcSetting = new ArcSetting("arcSetting", ArcSettingArgs.builder()
 *             .arcSettingName("default")
 *             .clusterName("myCluster")
 *             .resourceGroupName("test-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:ArcSetting myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/arcSettings/{arcSettingName}
 * ```
 */
public class ArcSetting internal constructor(
    override val javaResource: com.pulumi.azurenative.azurestackhci.ArcSetting,
) : KotlinCustomResource(javaResource, ArcSettingMapper) {
    /**
     * Aggregate state of Arc agent across the nodes in this HCI cluster.
     */
    public val aggregateState: Output<String>
        get() = javaResource.aggregateState().applyValue({ args0 -> args0 })

    /**
     * App id of arc AAD identity.
     */
    public val arcApplicationClientId: Output<String>?
        get() = javaResource.arcApplicationClientId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Object id of arc AAD identity.
     */
    public val arcApplicationObjectId: Output<String>?
        get() = javaResource.arcApplicationObjectId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Tenant id of arc AAD identity.
     */
    public val arcApplicationTenantId: Output<String>?
        get() = javaResource.arcApplicationTenantId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource group that hosts the Arc agents, ie. Hybrid Compute Machine resources.
     */
    public val arcInstanceResourceGroup: Output<String>?
        get() = javaResource.arcInstanceResourceGroup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Object id of arc AAD service principal.
     */
    public val arcServicePrincipalObjectId: Output<String>?
        get() = javaResource.arcServicePrincipalObjectId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * contains connectivity related configuration for ARC resources
     */
    public val connectivityProperties: Output<List<ArcConnectivityPropertiesResponse>>?
        get() = javaResource.connectivityProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        arcConnectivityPropertiesResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Properties for each of the default extensions category
     */
    public val defaultExtensions: Output<List<DefaultExtensionDetailsResponse>>
        get() = javaResource.defaultExtensions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> defaultExtensionDetailsResponseToKotlin(args0) })
            })
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of Arc agent in each of the nodes.
     */
    public val perNodeDetails: Output<List<PerNodeStateResponse>>
        get() = javaResource.perNodeDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> perNodeStateResponseToKotlin(args0) })
            })
        })

    /**
     * Provisioning state of the ArcSetting proxy resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ArcSettingMapper : ResourceMapper<ArcSetting> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurestackhci.ArcSetting::class == javaResource::class

    override fun map(javaResource: Resource): ArcSetting = ArcSetting(
        javaResource as
            com.pulumi.azurenative.azurestackhci.ArcSetting,
    )
}

/**
 * @see [ArcSetting].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ArcSetting].
 */
public suspend fun arcSetting(name: String, block: suspend ArcSettingResourceBuilder.() -> Unit):
    ArcSetting {
    val builder = ArcSettingResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ArcSetting].
 * @param name The _unique_ name of the resulting resource.
 */
public fun arcSetting(name: String): ArcSetting {
    val builder = ArcSettingResourceBuilder()
    builder.name(name)
    return builder.build()
}
