@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.kotlin.outputs.PerNodeExtensionStateResponse
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.PerNodeExtensionStateResponse.Companion.toKotlin as perNodeExtensionStateResponseToKotlin
import com.pulumi.azurenative.azurestackhci.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Extension].
 */
@PulumiTagMarker
public class ExtensionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExtensionArgs = ExtensionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExtensionArgsBuilder.() -> Unit) {
        val builder = ExtensionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Extension {
        val builtJavaResource = com.pulumi.azurenative.azurestackhci.Extension(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Extension(builtJavaResource)
    }
}

/**
 * Details of a particular extension in HCI Cluster.
 * Azure REST API version: 2023-03-01. Prior API version in Azure Native 1.x: 2021-01-01-preview.
 * Other available API versions: 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview.
 * ## Example Usage
 * ### Create Arc Extension
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var extension = new AzureNative.AzureStackHCI.Extension("extension", new()
 *     {
 *         ArcSettingName = "default",
 *         ClusterName = "myCluster",
 *         EnableAutomaticUpgrade = false,
 *         ExtensionName = "MicrosoftMonitoringAgent",
 *         ProtectedSettings =
 *         {
 *             { "workspaceKey", "xx" },
 *         },
 *         Publisher = "Microsoft.Compute",
 *         ResourceGroupName = "test-rg",
 *         Settings =
 *         {
 *             { "workspaceId", "xx" },
 *         },
 *         Type = "MicrosoftMonitoringAgent",
 *         TypeHandlerVersion = "1.10",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewExtension(ctx, "extension", &azurestackhci.ExtensionArgs{
 * 			ArcSettingName:         pulumi.String("default"),
 * 			ClusterName:            pulumi.String("myCluster"),
 * 			EnableAutomaticUpgrade: pulumi.Bool(false),
 * 			ExtensionName:          pulumi.String("MicrosoftMonitoringAgent"),
 * 			ProtectedSettings: pulumi.Any{
 * 				WorkspaceKey: "xx",
 * 			},
 * 			Publisher:         pulumi.String("Microsoft.Compute"),
 * 			ResourceGroupName: pulumi.String("test-rg"),
 * 			Settings: pulumi.Any{
 * 				WorkspaceId: "xx",
 * 			},
 * 			Type:               pulumi.String("MicrosoftMonitoringAgent"),
 * 			TypeHandlerVersion: pulumi.String("1.10"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.Extension;
 * import com.pulumi.azurenative.azurestackhci.ExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var extension = new Extension("extension", ExtensionArgs.builder()
 *             .arcSettingName("default")
 *             .clusterName("myCluster")
 *             .enableAutomaticUpgrade(false)
 *             .extensionName("MicrosoftMonitoringAgent")
 *             .protectedSettings(Map.of("workspaceKey", "xx"))
 *             .publisher("Microsoft.Compute")
 *             .resourceGroupName("test-rg")
 *             .settings(Map.of("workspaceId", "xx"))
 *             .type("MicrosoftMonitoringAgent")
 *             .typeHandlerVersion("1.10")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:Extension MicrosoftMonitoringAgent /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/arcSettings/{arcSettingName}/extensions/{extensionName}
 * ```
 */
public class Extension internal constructor(
    override val javaResource: com.pulumi.azurenative.azurestackhci.Extension,
) : KotlinCustomResource(javaResource, ExtensionMapper) {
    /**
     * Aggregate state of Arc Extensions across the nodes in this HCI cluster.
     */
    public val aggregateState: Output<String>
        get() = javaResource.aggregateState().applyValue({ args0 -> args0 })

    /**
     * Indicates whether the extension should use a newer minor version if one is available at deployment time. Once deployed, however, the extension will not upgrade minor versions unless redeployed, even with this property set to true.
     */
    public val autoUpgradeMinorVersion: Output<Boolean>?
        get() = javaResource.autoUpgradeMinorVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates whether the extension should be automatically upgraded by the platform if there is a newer version available.
     */
    public val enableAutomaticUpgrade: Output<Boolean>?
        get() = javaResource.enableAutomaticUpgrade().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * How the extension handler should be forced to update even if the extension configuration has not changed.
     */
    public val forceUpdateTag: Output<String>?
        get() = javaResource.forceUpdateTag().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Indicates if the extension is managed by azure or the user.
     */
    public val managedBy: Output<String>
        get() = javaResource.managedBy().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of Arc Extension in each of the nodes.
     */
    public val perNodeExtensionDetails: Output<List<PerNodeExtensionStateResponse>>
        get() = javaResource.perNodeExtensionDetails().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> perNodeExtensionStateResponseToKotlin(args0) })
            })
        })

    /**
     * Protected settings (may contain secrets).
     */
    public val protectedSettings: Output<Any>?
        get() = javaResource.protectedSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning state of the Extension proxy resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The name of the extension handler publisher.
     */
    public val publisher: Output<String>?
        get() = javaResource.publisher().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Json formatted public settings for the extension.
     */
    public val settings: Output<Any>?
        get() = javaResource.settings().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Specifies the version of the script handler. Latest version would be used if not specified.
     */
    public val typeHandlerVersion: Output<String>?
        get() = javaResource.typeHandlerVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object ExtensionMapper : ResourceMapper<Extension> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.azurestackhci.Extension::class == javaResource::class

    override fun map(javaResource: Resource): Extension = Extension(
        javaResource as
            com.pulumi.azurenative.azurestackhci.Extension,
    )
}

/**
 * @see [Extension].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Extension].
 */
public suspend fun extension(name: String, block: suspend ExtensionResourceBuilder.() -> Unit):
    Extension {
    val builder = ExtensionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Extension].
 * @param name The _unique_ name of the resulting resource.
 */
public fun extension(name: String): Extension {
    val builder = ExtensionResourceBuilder()
    builder.name(name)
    return builder.build()
}
