@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.MarketplaceGalleryImageArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.CloudInitDataSource
import com.pulumi.azurenative.azurestackhci.kotlin.enums.HyperVGeneration
import com.pulumi.azurenative.azurestackhci.kotlin.enums.OperatingSystemTypes
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GalleryImageIdentifierArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GalleryImageIdentifierArgsBuilder
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GalleryImageVersionArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.GalleryImageVersionArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The marketplace gallery image resource definition.
 * Azure REST API version: 2022-12-15-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview.
 * ## Example Usage
 * ### PutMarketplaceGalleryImage
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var marketplaceGalleryImage = new AzureNative.AzureStackHCI.MarketplaceGalleryImage("marketplaceGalleryImage", new()
 *     {
 *         CloudInitDataSource = "Azure",
 *         ContainerName = "Default_Container",
 *         ExtendedLocation = new AzureNative.AzureStackHCI.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location",
 *             Type = "CustomLocation",
 *         },
 *         HyperVGeneration = "V1",
 *         Identifier = new AzureNative.AzureStackHCI.Inputs.GalleryImageIdentifierArgs
 *         {
 *             Offer = "myOfferName",
 *             Publisher = "myPublisherName",
 *             Sku = "mySkuName",
 *         },
 *         Location = "West US2",
 *         MarketplaceGalleryImageName = "test-marketplace-gallery-image",
 *         OsType = AzureNative.AzureStackHCI.OperatingSystemTypes.Windows,
 *         ResourceGroupName = "test-rg",
 *         Version = new AzureNative.AzureStackHCI.Inputs.GalleryImageVersionArgs
 *         {
 *             Name = "1.0.0",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewMarketplaceGalleryImage(ctx, "marketplaceGalleryImage", &azurestackhci.MarketplaceGalleryImageArgs{
 * 			CloudInitDataSource: pulumi.String("Azure"),
 * 			ContainerName:       pulumi.String("Default_Container"),
 * 			ExtendedLocation: &azurestackhci.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			HyperVGeneration: pulumi.String("V1"),
 * 			Identifier: &azurestackhci.GalleryImageIdentifierArgs{
 * 				Offer:     pulumi.String("myOfferName"),
 * 				Publisher: pulumi.String("myPublisherName"),
 * 				Sku:       pulumi.String("mySkuName"),
 * 			},
 * 			Location:                    pulumi.String("West US2"),
 * 			MarketplaceGalleryImageName: pulumi.String("test-marketplace-gallery-image"),
 * 			OsType:                      azurestackhci.OperatingSystemTypesWindows,
 * 			ResourceGroupName:           pulumi.String("test-rg"),
 * 			Version: &azurestackhci.GalleryImageVersionArgs{
 * 				Name: pulumi.String("1.0.0"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.MarketplaceGalleryImage;
 * import com.pulumi.azurenative.azurestackhci.MarketplaceGalleryImageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var marketplaceGalleryImage = new MarketplaceGalleryImage("marketplaceGalleryImage", MarketplaceGalleryImageArgs.builder()
 *             .cloudInitDataSource("Azure")
 *             .containerName("Default_Container")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/a95612cb-f1fa-4daa-a4fd-272844fa512c/resourceGroups/dogfoodarc/providers/Microsoft.ExtendedLocation/customLocations/dogfood-location"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .hyperVGeneration("V1")
 *             .identifier(Map.ofEntries(
 *                 Map.entry("offer", "myOfferName"),
 *                 Map.entry("publisher", "myPublisherName"),
 *                 Map.entry("sku", "mySkuName")
 *             ))
 *             .location("West US2")
 *             .marketplaceGalleryImageName("test-marketplace-gallery-image")
 *             .osType("Windows")
 *             .resourceGroupName("test-rg")
 *             .version(Map.of("name", "1.0.0"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:MarketplaceGalleryImage test-marketplace-gallery-image /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/marketplaceGalleryImages/{marketplaceGalleryImageName}
 * ```
 * @property cloudInitDataSource Datasource for the gallery image when provisioning with cloud-init [NoCloud, Azure]
 * @property containerName Container Name for storage container
 * @property extendedLocation The extendedLocation of the resource.
 * @property hyperVGeneration The hypervisor generation of the Virtual Machine [V1, V2]
 * @property identifier This is the gallery image definition identifier.
 * @property location The geo-location where the resource lives
 * @property marketplaceGalleryImageName Name of the marketplace gallery image
 * @property osType Operating system type that the gallery image uses [Windows, Linux]
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property version Specifies information about the gallery image version that you want to create or update.
 */
public data class MarketplaceGalleryImageArgs(
    public val cloudInitDataSource: Output<Either<String, CloudInitDataSource>>? = null,
    public val containerName: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val hyperVGeneration: Output<Either<String, HyperVGeneration>>? = null,
    public val identifier: Output<GalleryImageIdentifierArgs>? = null,
    public val location: Output<String>? = null,
    public val marketplaceGalleryImageName: Output<String>? = null,
    public val osType: Output<OperatingSystemTypes>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<GalleryImageVersionArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.MarketplaceGalleryImageArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.MarketplaceGalleryImageArgs =
        com.pulumi.azurenative.azurestackhci.MarketplaceGalleryImageArgs.builder()
            .cloudInitDataSource(
                cloudInitDataSource?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hyperVGeneration(
                hyperVGeneration?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .identifier(identifier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .marketplaceGalleryImageName(marketplaceGalleryImageName?.applyValue({ args0 -> args0 }))
            .osType(osType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MarketplaceGalleryImageArgs].
 */
@PulumiTagMarker
public class MarketplaceGalleryImageArgsBuilder internal constructor() {
    private var cloudInitDataSource: Output<Either<String, CloudInitDataSource>>? = null

    private var containerName: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var hyperVGeneration: Output<Either<String, HyperVGeneration>>? = null

    private var identifier: Output<GalleryImageIdentifierArgs>? = null

    private var location: Output<String>? = null

    private var marketplaceGalleryImageName: Output<String>? = null

    private var osType: Output<OperatingSystemTypes>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<GalleryImageVersionArgs>? = null

    /**
     * @param value Datasource for the gallery image when provisioning with cloud-init [NoCloud, Azure]
     */
    @JvmName("ashduugtomqdqlgv")
    public suspend fun cloudInitDataSource(`value`: Output<Either<String, CloudInitDataSource>>) {
        this.cloudInitDataSource = value
    }

    /**
     * @param value Container Name for storage container
     */
    @JvmName("pinngqtdesenkhuc")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("mfrksmddsyhehnee")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine [V1, V2]
     */
    @JvmName("uveggqgttnpacxru")
    public suspend fun hyperVGeneration(`value`: Output<Either<String, HyperVGeneration>>) {
        this.hyperVGeneration = value
    }

    /**
     * @param value This is the gallery image definition identifier.
     */
    @JvmName("ymcxocjhdifbfgjv")
    public suspend fun identifier(`value`: Output<GalleryImageIdentifierArgs>) {
        this.identifier = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rlsnenvrcgbnoogb")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the marketplace gallery image
     */
    @JvmName("mjelhobfgblnpvlg")
    public suspend fun marketplaceGalleryImageName(`value`: Output<String>) {
        this.marketplaceGalleryImageName = value
    }

    /**
     * @param value Operating system type that the gallery image uses [Windows, Linux]
     */
    @JvmName("tltyakwdmhbcetoq")
    public suspend fun osType(`value`: Output<OperatingSystemTypes>) {
        this.osType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vufbdjjvcfvpxwbc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("qtopknsekrpnbdim")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies information about the gallery image version that you want to create or update.
     */
    @JvmName("vgpaakuhqjrknwdc")
    public suspend fun version(`value`: Output<GalleryImageVersionArgs>) {
        this.version = value
    }

    /**
     * @param value Datasource for the gallery image when provisioning with cloud-init [NoCloud, Azure]
     */
    @JvmName("aitkhacrmvvhpgie")
    public suspend fun cloudInitDataSource(`value`: Either<String, CloudInitDataSource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudInitDataSource = mapped
    }

    /**
     * @param value Datasource for the gallery image when provisioning with cloud-init [NoCloud, Azure]
     */
    @JvmName("rxccupgypkyefkic")
    public fun cloudInitDataSource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CloudInitDataSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudInitDataSource = mapped
    }

    /**
     * @param value Datasource for the gallery image when provisioning with cloud-init [NoCloud, Azure]
     */
    @JvmName("fysfupeyedhoveqb")
    public fun cloudInitDataSource(`value`: CloudInitDataSource) {
        val toBeMapped = Either.ofRight<String, CloudInitDataSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cloudInitDataSource = mapped
    }

    /**
     * @param value Container Name for storage container
     */
    @JvmName("eculvvparkkjqytu")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value The extendedLocation of the resource.
     */
    @JvmName("ildvfxoyndjnwmwl")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extendedLocation of the resource.
     */
    @JvmName("olnwvmnymhsqcrrt")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine [V1, V2]
     */
    @JvmName("ujcwwhbqiepgtogb")
    public suspend fun hyperVGeneration(`value`: Either<String, HyperVGeneration>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine [V1, V2]
     */
    @JvmName("bsdjuramrfvjgrpl")
    public fun hyperVGeneration(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HyperVGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value The hypervisor generation of the Virtual Machine [V1, V2]
     */
    @JvmName("hunnwnuncyuqjjjf")
    public fun hyperVGeneration(`value`: HyperVGeneration) {
        val toBeMapped = Either.ofRight<String, HyperVGeneration>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hyperVGeneration = mapped
    }

    /**
     * @param value This is the gallery image definition identifier.
     */
    @JvmName("gxhtmjfxeoamisxu")
    public suspend fun identifier(`value`: GalleryImageIdentifierArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    /**
     * @param argument This is the gallery image definition identifier.
     */
    @JvmName("yoapervwciykrpjn")
    public suspend fun identifier(argument: suspend GalleryImageIdentifierArgsBuilder.() -> Unit) {
        val toBeMapped = GalleryImageIdentifierArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identifier = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("cybcqnbyurabpbhf")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the marketplace gallery image
     */
    @JvmName("rlancwjbyvmwpnps")
    public suspend fun marketplaceGalleryImageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.marketplaceGalleryImageName = mapped
    }

    /**
     * @param value Operating system type that the gallery image uses [Windows, Linux]
     */
    @JvmName("xacttkgsdectmfia")
    public suspend fun osType(`value`: OperatingSystemTypes?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tttwjqvvyiabditp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("pkrkhbqanrgthtiy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("frqsvaobojdhkimf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies information about the gallery image version that you want to create or update.
     */
    @JvmName("qavsnebfuuokadnu")
    public suspend fun version(`value`: GalleryImageVersionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param argument Specifies information about the gallery image version that you want to create or update.
     */
    @JvmName("dgbjxfdykdgdnolv")
    public suspend fun version(argument: suspend GalleryImageVersionArgsBuilder.() -> Unit) {
        val toBeMapped = GalleryImageVersionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.version = mapped
    }

    internal fun build(): MarketplaceGalleryImageArgs = MarketplaceGalleryImageArgs(
        cloudInitDataSource = cloudInitDataSource,
        containerName = containerName,
        extendedLocation = extendedLocation,
        hyperVGeneration = hyperVGeneration,
        identifier = identifier,
        location = location,
        marketplaceGalleryImageName = marketplaceGalleryImageName,
        osType = osType,
        resourceGroupName = resourceGroupName,
        tags = tags,
        version = version,
    )
}
