@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin

import com.pulumi.azurenative.azurestackhci.UpdateArgs.builder
import com.pulumi.azurenative.azurestackhci.kotlin.enums.AvailabilityType
import com.pulumi.azurenative.azurestackhci.kotlin.enums.State
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.UpdatePrerequisiteArgs
import com.pulumi.azurenative.azurestackhci.kotlin.inputs.UpdatePrerequisiteArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Update details
 * Azure REST API version: 2023-03-01.
 * Other available API versions: 2022-12-15-preview, 2023-06-01, 2023-08-01, 2023-08-01-preview.
 * ## Example Usage
 * ### Put a specific update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var update = new AzureNative.AzureStackHCI.Update("update", new()
 *     {
 *         AdditionalProperties = "additional properties",
 *         AvailabilityType = "Local",
 *         ClusterName = "testcluster",
 *         Description = "AzS Update 4.2203.2.32",
 *         DisplayName = "AzS Update - 4.2203.2.32",
 *         InstalledDate = "2022-04-06T14:08:18.254Z",
 *         NotifyMessage = "Brief message with instructions for updates of AvailabilityType Notify",
 *         PackagePath = "\\\\SU1FileServer\\SU1_Infrastructure_2\\Updates\\Packages\\Microsoft4.2203.2.32",
 *         PackageSizeInMb = 18858,
 *         PackageType = "Infrastructure",
 *         Prerequisites = new[]
 *         {
 *             new AzureNative.AzureStackHCI.Inputs.UpdatePrerequisiteArgs
 *             {
 *                 PackageName = "update package name",
 *                 UpdateType = "update type",
 *                 Version = "prerequisite version",
 *             },
 *         },
 *         ProgressPercentage = 0,
 *         Publisher = "Microsoft",
 *         ReleaseLink = "https://docs.microsoft.com/azure-stack/operator/release-notes?view=azs-2203",
 *         ResourceGroupName = "testrg",
 *         State = "Installed",
 *         UpdateName = "Microsoft4.2203.2.32",
 *         Version = "4.2203.2.32",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/azurestackhci/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := azurestackhci.NewUpdate(ctx, "update", &azurestackhci.UpdateArgs{
 * 			AdditionalProperties: pulumi.String("additional properties"),
 * 			AvailabilityType:     pulumi.String("Local"),
 * 			ClusterName:          pulumi.String("testcluster"),
 * 			Description:          pulumi.String("AzS Update 4.2203.2.32"),
 * 			DisplayName:          pulumi.String("AzS Update - 4.2203.2.32"),
 * 			InstalledDate:        pulumi.String("2022-04-06T14:08:18.254Z"),
 * 			NotifyMessage:        pulumi.String("Brief message with instructions for updates of AvailabilityType Notify"),
 * 			PackagePath:          pulumi.String("\\\\SU1FileServer\\SU1_Infrastructure_2\\Updates\\Packages\\Microsoft4.2203.2.32"),
 * 			PackageSizeInMb:      pulumi.Float64(18858),
 * 			PackageType:          pulumi.String("Infrastructure"),
 * 			Prerequisites: []azurestackhci.UpdatePrerequisiteArgs{
 * 				{
 * 					PackageName: pulumi.String("update package name"),
 * 					UpdateType:  pulumi.String("update type"),
 * 					Version:     pulumi.String("prerequisite version"),
 * 				},
 * 			},
 * 			ProgressPercentage: pulumi.Float64(0),
 * 			Publisher:          pulumi.String("Microsoft"),
 * 			ReleaseLink:        pulumi.String("https://docs.microsoft.com/azure-stack/operator/release-notes?view=azs-2203"),
 * 			ResourceGroupName:  pulumi.String("testrg"),
 * 			State:              pulumi.String("Installed"),
 * 			UpdateName:         pulumi.String("Microsoft4.2203.2.32"),
 * 			Version:            pulumi.String("4.2203.2.32"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.azurestackhci.Update;
 * import com.pulumi.azurenative.azurestackhci.UpdateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var update = new Update("update", UpdateArgs.builder()
 *             .additionalProperties("additional properties")
 *             .availabilityType("Local")
 *             .clusterName("testcluster")
 *             .description("AzS Update 4.2203.2.32")
 *             .displayName("AzS Update - 4.2203.2.32")
 *             .installedDate("2022-04-06T14:08:18.254Z")
 *             .notifyMessage("Brief message with instructions for updates of AvailabilityType Notify")
 *             .packagePath("\\\\SU1FileServer\\SU1_Infrastructure_2\\Updates\\Packages\\Microsoft4.2203.2.32")
 *             .packageSizeInMb(18858)
 *             .packageType("Infrastructure")
 *             .prerequisites(Map.ofEntries(
 *                 Map.entry("packageName", "update package name"),
 *                 Map.entry("updateType", "update type"),
 *                 Map.entry("version", "prerequisite version")
 *             ))
 *             .progressPercentage(0)
 *             .publisher("Microsoft")
 *             .releaseLink("https://docs.microsoft.com/azure-stack/operator/release-notes?view=azs-2203")
 *             .resourceGroupName("testrg")
 *             .state("Installed")
 *             .updateName("Microsoft4.2203.2.32")
 *             .version("4.2203.2.32")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:azurestackhci:Update Microsoft4.2203.2.32 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureStackHCI/clusters/{clusterName}/updates/{updateName}
 * ```
 * @property additionalProperties Extensible KV pairs serialized as a string. This is currently used to report the stamp OEM family and hardware model information when an update is flagged as Invalid for the stamp based on OEM type.
 * @property availabilityType Indicates the way the update content can be downloaded.
 * @property clusterName The name of the cluster.
 * @property description Description of the update.
 * @property displayName Display name of the Update
 * @property healthCheckDate Last time the package-specific checks were run.
 * @property installedDate Date that the update was installed.
 * @property location The geo-location where the resource lives
 * @property notifyMessage Brief message with instructions for updates of AvailabilityType Notify.
 * @property packagePath Path where the update package is available.
 * @property packageSizeInMb Size of the package. This value is a combination of the size from update metadata and size of the payload that results from the live scan operation for OS update content.
 * @property packageType Customer-visible type of the update.
 * @property prerequisites If update State is HasPrerequisite, this property contains an array of objects describing prerequisite updates before installing this update. Otherwise, it is empty.
 * @property progressPercentage Progress percentage of ongoing operation. Currently this property is only valid when the update is in the Downloading state, where it maps to how much of the update content has been downloaded.
 * @property publisher Publisher of the update package.
 * @property releaseLink Link to release notes for the update.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property state State of the update as it relates to this stamp.
 * @property updateName The name of the Update
 * @property version Version of the update.
 */
public data class UpdateArgs(
    public val additionalProperties: Output<String>? = null,
    public val availabilityType: Output<Either<String, AvailabilityType>>? = null,
    public val clusterName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val healthCheckDate: Output<String>? = null,
    public val installedDate: Output<String>? = null,
    public val location: Output<String>? = null,
    public val notifyMessage: Output<String>? = null,
    public val packagePath: Output<String>? = null,
    public val packageSizeInMb: Output<Double>? = null,
    public val packageType: Output<String>? = null,
    public val prerequisites: Output<List<UpdatePrerequisiteArgs>>? = null,
    public val progressPercentage: Output<Double>? = null,
    public val publisher: Output<String>? = null,
    public val releaseLink: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val state: Output<Either<String, State>>? = null,
    public val updateName: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.UpdateArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.UpdateArgs =
        com.pulumi.azurenative.azurestackhci.UpdateArgs.builder()
            .additionalProperties(additionalProperties?.applyValue({ args0 -> args0 }))
            .availabilityType(
                availabilityType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .healthCheckDate(healthCheckDate?.applyValue({ args0 -> args0 }))
            .installedDate(installedDate?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .notifyMessage(notifyMessage?.applyValue({ args0 -> args0 }))
            .packagePath(packagePath?.applyValue({ args0 -> args0 }))
            .packageSizeInMb(packageSizeInMb?.applyValue({ args0 -> args0 }))
            .packageType(packageType?.applyValue({ args0 -> args0 }))
            .prerequisites(
                prerequisites?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .progressPercentage(progressPercentage?.applyValue({ args0 -> args0 }))
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .releaseLink(releaseLink?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .updateName(updateName?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UpdateArgs].
 */
@PulumiTagMarker
public class UpdateArgsBuilder internal constructor() {
    private var additionalProperties: Output<String>? = null

    private var availabilityType: Output<Either<String, AvailabilityType>>? = null

    private var clusterName: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var healthCheckDate: Output<String>? = null

    private var installedDate: Output<String>? = null

    private var location: Output<String>? = null

    private var notifyMessage: Output<String>? = null

    private var packagePath: Output<String>? = null

    private var packageSizeInMb: Output<Double>? = null

    private var packageType: Output<String>? = null

    private var prerequisites: Output<List<UpdatePrerequisiteArgs>>? = null

    private var progressPercentage: Output<Double>? = null

    private var publisher: Output<String>? = null

    private var releaseLink: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var state: Output<Either<String, State>>? = null

    private var updateName: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Extensible KV pairs serialized as a string. This is currently used to report the stamp OEM family and hardware model information when an update is flagged as Invalid for the stamp based on OEM type.
     */
    @JvmName("jykuemsbcqclyqhd")
    public suspend fun additionalProperties(`value`: Output<String>) {
        this.additionalProperties = value
    }

    /**
     * @param value Indicates the way the update content can be downloaded.
     */
    @JvmName("skedawtdxnorbrmt")
    public suspend fun availabilityType(`value`: Output<Either<String, AvailabilityType>>) {
        this.availabilityType = value
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("cjpmprkcjqthhxsg")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Description of the update.
     */
    @JvmName("astvvghicepjdtrg")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Display name of the Update
     */
    @JvmName("jaxcvgrlqnupvivu")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Last time the package-specific checks were run.
     */
    @JvmName("lointfpxulnjrlhi")
    public suspend fun healthCheckDate(`value`: Output<String>) {
        this.healthCheckDate = value
    }

    /**
     * @param value Date that the update was installed.
     */
    @JvmName("upwhhgwrmigeqjta")
    public suspend fun installedDate(`value`: Output<String>) {
        this.installedDate = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gljiytmibyiqtytx")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Brief message with instructions for updates of AvailabilityType Notify.
     */
    @JvmName("hmxfaugnniucnolu")
    public suspend fun notifyMessage(`value`: Output<String>) {
        this.notifyMessage = value
    }

    /**
     * @param value Path where the update package is available.
     */
    @JvmName("bckohedgnmypwojd")
    public suspend fun packagePath(`value`: Output<String>) {
        this.packagePath = value
    }

    /**
     * @param value Size of the package. This value is a combination of the size from update metadata and size of the payload that results from the live scan operation for OS update content.
     */
    @JvmName("htsuyxdjtyatfnwo")
    public suspend fun packageSizeInMb(`value`: Output<Double>) {
        this.packageSizeInMb = value
    }

    /**
     * @param value Customer-visible type of the update.
     */
    @JvmName("kfqrbaoceyndwvbn")
    public suspend fun packageType(`value`: Output<String>) {
        this.packageType = value
    }

    /**
     * @param value If update State is HasPrerequisite, this property contains an array of objects describing prerequisite updates before installing this update. Otherwise, it is empty.
     */
    @JvmName("srujsrgukifqunfh")
    public suspend fun prerequisites(`value`: Output<List<UpdatePrerequisiteArgs>>) {
        this.prerequisites = value
    }

    @JvmName("kpceauthhmfrdwrm")
    public suspend fun prerequisites(vararg values: Output<UpdatePrerequisiteArgs>) {
        this.prerequisites = Output.all(values.asList())
    }

    /**
     * @param values If update State is HasPrerequisite, this property contains an array of objects describing prerequisite updates before installing this update. Otherwise, it is empty.
     */
    @JvmName("ajxvnlyfexnytfla")
    public suspend fun prerequisites(values: List<Output<UpdatePrerequisiteArgs>>) {
        this.prerequisites = Output.all(values)
    }

    /**
     * @param value Progress percentage of ongoing operation. Currently this property is only valid when the update is in the Downloading state, where it maps to how much of the update content has been downloaded.
     */
    @JvmName("utdjsfojvjwynavs")
    public suspend fun progressPercentage(`value`: Output<Double>) {
        this.progressPercentage = value
    }

    /**
     * @param value Publisher of the update package.
     */
    @JvmName("hogqoabnqrvflrfo")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value Link to release notes for the update.
     */
    @JvmName("rmkgumhpjxyhocii")
    public suspend fun releaseLink(`value`: Output<String>) {
        this.releaseLink = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oeankwltargdexmy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value State of the update as it relates to this stamp.
     */
    @JvmName("wnyvpkhpluddmytg")
    public suspend fun state(`value`: Output<Either<String, State>>) {
        this.state = value
    }

    /**
     * @param value The name of the Update
     */
    @JvmName("dqvbqhesuryqhbna")
    public suspend fun updateName(`value`: Output<String>) {
        this.updateName = value
    }

    /**
     * @param value Version of the update.
     */
    @JvmName("kquvmudauomwlnji")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Extensible KV pairs serialized as a string. This is currently used to report the stamp OEM family and hardware model information when an update is flagged as Invalid for the stamp based on OEM type.
     */
    @JvmName("wsbnsagkhmmvvktq")
    public suspend fun additionalProperties(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalProperties = mapped
    }

    /**
     * @param value Indicates the way the update content can be downloaded.
     */
    @JvmName("nfvtjisrswbvebhj")
    public suspend fun availabilityType(`value`: Either<String, AvailabilityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityType = mapped
    }

    /**
     * @param value Indicates the way the update content can be downloaded.
     */
    @JvmName("kyxksjdceewolwkq")
    public fun availabilityType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AvailabilityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityType = mapped
    }

    /**
     * @param value Indicates the way the update content can be downloaded.
     */
    @JvmName("vmrbbooujvxegytj")
    public fun availabilityType(`value`: AvailabilityType) {
        val toBeMapped = Either.ofRight<String, AvailabilityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityType = mapped
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("abtbjuisahflsols")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Description of the update.
     */
    @JvmName("bkfmrspfqolhwsmr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Display name of the Update
     */
    @JvmName("hciuglflhkviwgux")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Last time the package-specific checks were run.
     */
    @JvmName("pvsfeilckcklgdye")
    public suspend fun healthCheckDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckDate = mapped
    }

    /**
     * @param value Date that the update was installed.
     */
    @JvmName("snampkhsvlujlctg")
    public suspend fun installedDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installedDate = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("akpqlnlcrhlhiusy")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Brief message with instructions for updates of AvailabilityType Notify.
     */
    @JvmName("iokfgvyugaiatyfq")
    public suspend fun notifyMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifyMessage = mapped
    }

    /**
     * @param value Path where the update package is available.
     */
    @JvmName("vssxbwikqnskjrdg")
    public suspend fun packagePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packagePath = mapped
    }

    /**
     * @param value Size of the package. This value is a combination of the size from update metadata and size of the payload that results from the live scan operation for OS update content.
     */
    @JvmName("thramxjvsvvfnrqw")
    public suspend fun packageSizeInMb(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageSizeInMb = mapped
    }

    /**
     * @param value Customer-visible type of the update.
     */
    @JvmName("idjnkkkufhcimdku")
    public suspend fun packageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageType = mapped
    }

    /**
     * @param value If update State is HasPrerequisite, this property contains an array of objects describing prerequisite updates before installing this update. Otherwise, it is empty.
     */
    @JvmName("pijnffbpebxsgxqh")
    public suspend fun prerequisites(`value`: List<UpdatePrerequisiteArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prerequisites = mapped
    }

    /**
     * @param argument If update State is HasPrerequisite, this property contains an array of objects describing prerequisite updates before installing this update. Otherwise, it is empty.
     */
    @JvmName("kjhjnnykwrfnhfnl")
    public suspend
    fun prerequisites(argument: List<suspend UpdatePrerequisiteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UpdatePrerequisiteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.prerequisites = mapped
    }

    /**
     * @param argument If update State is HasPrerequisite, this property contains an array of objects describing prerequisite updates before installing this update. Otherwise, it is empty.
     */
    @JvmName("eiovwoeghuexslqm")
    public suspend fun prerequisites(
        vararg
        argument: suspend UpdatePrerequisiteArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            UpdatePrerequisiteArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.prerequisites = mapped
    }

    /**
     * @param argument If update State is HasPrerequisite, this property contains an array of objects describing prerequisite updates before installing this update. Otherwise, it is empty.
     */
    @JvmName("gcmtvfcchcwbmoqs")
    public suspend fun prerequisites(argument: suspend UpdatePrerequisiteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UpdatePrerequisiteArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.prerequisites = mapped
    }

    /**
     * @param values If update State is HasPrerequisite, this property contains an array of objects describing prerequisite updates before installing this update. Otherwise, it is empty.
     */
    @JvmName("ljhafjjgoywwedni")
    public suspend fun prerequisites(vararg values: UpdatePrerequisiteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prerequisites = mapped
    }

    /**
     * @param value Progress percentage of ongoing operation. Currently this property is only valid when the update is in the Downloading state, where it maps to how much of the update content has been downloaded.
     */
    @JvmName("xahueywyuglvsrqy")
    public suspend fun progressPercentage(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.progressPercentage = mapped
    }

    /**
     * @param value Publisher of the update package.
     */
    @JvmName("iobrnqttogxkjbbo")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value Link to release notes for the update.
     */
    @JvmName("fbaykqujvncjomdc")
    public suspend fun releaseLink(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.releaseLink = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tvhdhkfdsonybtrc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value State of the update as it relates to this stamp.
     */
    @JvmName("ydtqklpyswvuqktn")
    public suspend fun state(`value`: Either<String, State>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value State of the update as it relates to this stamp.
     */
    @JvmName("dmfrycapvgiflexb")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value State of the update as it relates to this stamp.
     */
    @JvmName("qjufeopghafshsil")
    public fun state(`value`: State) {
        val toBeMapped = Either.ofRight<String, State>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The name of the Update
     */
    @JvmName("idsfwoqlidrevnat")
    public suspend fun updateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateName = mapped
    }

    /**
     * @param value Version of the update.
     */
    @JvmName("sijtsyliviwdmwnm")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): UpdateArgs = UpdateArgs(
        additionalProperties = additionalProperties,
        availabilityType = availabilityType,
        clusterName = clusterName,
        description = description,
        displayName = displayName,
        healthCheckDate = healthCheckDate,
        installedDate = installedDate,
        location = location,
        notifyMessage = notifyMessage,
        packagePath = packagePath,
        packageSizeInMb = packageSizeInMb,
        packageType = packageType,
        prerequisites = prerequisites,
        progressPercentage = progressPercentage,
        publisher = publisher,
        releaseLink = releaseLink,
        resourceGroupName = resourceGroupName,
        state = state,
        updateName = updateName,
        version = version,
    )
}
