@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of the network
 */
public enum class NetworkTypeEnum(
    public val javaValue: com.pulumi.azurenative.azurestackhci.enums.NetworkTypeEnum,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.enums.NetworkTypeEnum> {
    NAT(com.pulumi.azurenative.azurestackhci.enums.NetworkTypeEnum.NAT),
    Transparent(com.pulumi.azurenative.azurestackhci.enums.NetworkTypeEnum.Transparent),
    L2Bridge(com.pulumi.azurenative.azurestackhci.enums.NetworkTypeEnum.L2Bridge),
    L2Tunnel(com.pulumi.azurenative.azurestackhci.enums.NetworkTypeEnum.L2Tunnel),
    ICS(com.pulumi.azurenative.azurestackhci.enums.NetworkTypeEnum.ICS),
    Private(com.pulumi.azurenative.azurestackhci.enums.NetworkTypeEnum.Private),
    Overlay(com.pulumi.azurenative.azurestackhci.enums.NetworkTypeEnum.Overlay),
    Internal(com.pulumi.azurenative.azurestackhci.enums.NetworkTypeEnum.Internal),
    Mirrored(com.pulumi.azurenative.azurestackhci.enums.NetworkTypeEnum.Mirrored),
    ;

    override fun toJava(): com.pulumi.azurenative.azurestackhci.enums.NetworkTypeEnum = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.azurestackhci.enums.NetworkTypeEnum):
            NetworkTypeEnum = NetworkTypeEnum.values().first { it.javaValue == javaType }
    }
}
