@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.DeploymentDataArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The Deployment data of AzureStackHCI Cluster.
 * @property adouPath The path to the Active Directory Organizational Unit container object prepared for the deployment.
 * @property cluster Observability config to deploy AzureStackHCI Cluster.
 * @property domainFqdn FQDN to deploy cluster
 * @property hostNetwork HostNetwork config to deploy AzureStackHCI Cluster.
 * @property infrastructureNetwork InfrastructureNetwork config to deploy AzureStackHCI Cluster.
 * @property namingPrefix naming prefix to deploy cluster.
 * @property observability Observability config to deploy AzureStackHCI Cluster.
 * @property optionalServices OptionalServices config to deploy AzureStackHCI Cluster.
 * @property physicalNodes list of physical nodes config to deploy AzureStackHCI Cluster.
 * @property secretsLocation The URI to the keyvault / secret store.
 * @property securitySettings SecuritySettings to deploy AzureStackHCI Cluster.
 * @property storage Storage config to deploy AzureStackHCI Cluster.
 */
public data class DeploymentDataArgs(
    public val adouPath: Output<String>? = null,
    public val cluster: Output<ClusterArgs>? = null,
    public val domainFqdn: Output<String>? = null,
    public val hostNetwork: Output<HostNetworkArgs>? = null,
    public val infrastructureNetwork: Output<List<InfrastructureNetworkArgs>>? = null,
    public val namingPrefix: Output<String>? = null,
    public val observability: Output<ObservabilityArgs>? = null,
    public val optionalServices: Output<OptionalServicesArgs>? = null,
    public val physicalNodes: Output<List<PhysicalNodesArgs>>? = null,
    public val secretsLocation: Output<String>? = null,
    public val securitySettings: Output<SecuritySettingsArgs>? = null,
    public val storage: Output<StorageArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.DeploymentDataArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.DeploymentDataArgs =
        com.pulumi.azurenative.azurestackhci.inputs.DeploymentDataArgs.builder()
            .adouPath(adouPath?.applyValue({ args0 -> args0 }))
            .cluster(cluster?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .domainFqdn(domainFqdn?.applyValue({ args0 -> args0 }))
            .hostNetwork(hostNetwork?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .infrastructureNetwork(
                infrastructureNetwork?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .namingPrefix(namingPrefix?.applyValue({ args0 -> args0 }))
            .observability(observability?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .optionalServices(optionalServices?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .physicalNodes(
                physicalNodes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .secretsLocation(secretsLocation?.applyValue({ args0 -> args0 }))
            .securitySettings(securitySettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storage(storage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeploymentDataArgs].
 */
@PulumiTagMarker
public class DeploymentDataArgsBuilder internal constructor() {
    private var adouPath: Output<String>? = null

    private var cluster: Output<ClusterArgs>? = null

    private var domainFqdn: Output<String>? = null

    private var hostNetwork: Output<HostNetworkArgs>? = null

    private var infrastructureNetwork: Output<List<InfrastructureNetworkArgs>>? = null

    private var namingPrefix: Output<String>? = null

    private var observability: Output<ObservabilityArgs>? = null

    private var optionalServices: Output<OptionalServicesArgs>? = null

    private var physicalNodes: Output<List<PhysicalNodesArgs>>? = null

    private var secretsLocation: Output<String>? = null

    private var securitySettings: Output<SecuritySettingsArgs>? = null

    private var storage: Output<StorageArgs>? = null

    /**
     * @param value The path to the Active Directory Organizational Unit container object prepared for the deployment.
     */
    @JvmName("welchtcnhmcpcsdo")
    public suspend fun adouPath(`value`: Output<String>) {
        this.adouPath = value
    }

    /**
     * @param value Observability config to deploy AzureStackHCI Cluster.
     */
    @JvmName("jpounwowdyqosovs")
    public suspend fun cluster(`value`: Output<ClusterArgs>) {
        this.cluster = value
    }

    /**
     * @param value FQDN to deploy cluster
     */
    @JvmName("ntgnbowlipwxvxwp")
    public suspend fun domainFqdn(`value`: Output<String>) {
        this.domainFqdn = value
    }

    /**
     * @param value HostNetwork config to deploy AzureStackHCI Cluster.
     */
    @JvmName("umarbccqprpfwvyx")
    public suspend fun hostNetwork(`value`: Output<HostNetworkArgs>) {
        this.hostNetwork = value
    }

    /**
     * @param value InfrastructureNetwork config to deploy AzureStackHCI Cluster.
     */
    @JvmName("skakrvtwgkcouwtu")
    public suspend fun infrastructureNetwork(`value`: Output<List<InfrastructureNetworkArgs>>) {
        this.infrastructureNetwork = value
    }

    @JvmName("sypfqwhhhrgeaiuo")
    public suspend fun infrastructureNetwork(vararg values: Output<InfrastructureNetworkArgs>) {
        this.infrastructureNetwork = Output.all(values.asList())
    }

    /**
     * @param values InfrastructureNetwork config to deploy AzureStackHCI Cluster.
     */
    @JvmName("spmjovxumemqddvu")
    public suspend fun infrastructureNetwork(values: List<Output<InfrastructureNetworkArgs>>) {
        this.infrastructureNetwork = Output.all(values)
    }

    /**
     * @param value naming prefix to deploy cluster.
     */
    @JvmName("estufipekfewpijg")
    public suspend fun namingPrefix(`value`: Output<String>) {
        this.namingPrefix = value
    }

    /**
     * @param value Observability config to deploy AzureStackHCI Cluster.
     */
    @JvmName("roqnljktpogxjaqy")
    public suspend fun observability(`value`: Output<ObservabilityArgs>) {
        this.observability = value
    }

    /**
     * @param value OptionalServices config to deploy AzureStackHCI Cluster.
     */
    @JvmName("gymeifolkqpskwsk")
    public suspend fun optionalServices(`value`: Output<OptionalServicesArgs>) {
        this.optionalServices = value
    }

    /**
     * @param value list of physical nodes config to deploy AzureStackHCI Cluster.
     */
    @JvmName("pbnkidejelplxsxb")
    public suspend fun physicalNodes(`value`: Output<List<PhysicalNodesArgs>>) {
        this.physicalNodes = value
    }

    @JvmName("urgmuenajsbvcyli")
    public suspend fun physicalNodes(vararg values: Output<PhysicalNodesArgs>) {
        this.physicalNodes = Output.all(values.asList())
    }

    /**
     * @param values list of physical nodes config to deploy AzureStackHCI Cluster.
     */
    @JvmName("lhxvqbvwtdrkoysf")
    public suspend fun physicalNodes(values: List<Output<PhysicalNodesArgs>>) {
        this.physicalNodes = Output.all(values)
    }

    /**
     * @param value The URI to the keyvault / secret store.
     */
    @JvmName("hlgnyyrnveuchjym")
    public suspend fun secretsLocation(`value`: Output<String>) {
        this.secretsLocation = value
    }

    /**
     * @param value SecuritySettings to deploy AzureStackHCI Cluster.
     */
    @JvmName("quplvcyhngoixkax")
    public suspend fun securitySettings(`value`: Output<SecuritySettingsArgs>) {
        this.securitySettings = value
    }

    /**
     * @param value Storage config to deploy AzureStackHCI Cluster.
     */
    @JvmName("csskktpgdvomeoqc")
    public suspend fun storage(`value`: Output<StorageArgs>) {
        this.storage = value
    }

    /**
     * @param value The path to the Active Directory Organizational Unit container object prepared for the deployment.
     */
    @JvmName("kajgqfvfvxyiierk")
    public suspend fun adouPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adouPath = mapped
    }

    /**
     * @param value Observability config to deploy AzureStackHCI Cluster.
     */
    @JvmName("gpudbstehtgaovhm")
    public suspend fun cluster(`value`: ClusterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cluster = mapped
    }

    /**
     * @param argument Observability config to deploy AzureStackHCI Cluster.
     */
    @JvmName("fomljttkyvlnijna")
    public suspend fun cluster(argument: suspend ClusterArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cluster = mapped
    }

    /**
     * @param value FQDN to deploy cluster
     */
    @JvmName("bbpyygxvlaxurnur")
    public suspend fun domainFqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainFqdn = mapped
    }

    /**
     * @param value HostNetwork config to deploy AzureStackHCI Cluster.
     */
    @JvmName("gffviontarhycrlq")
    public suspend fun hostNetwork(`value`: HostNetworkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostNetwork = mapped
    }

    /**
     * @param argument HostNetwork config to deploy AzureStackHCI Cluster.
     */
    @JvmName("scfmajxcosaembts")
    public suspend fun hostNetwork(argument: suspend HostNetworkArgsBuilder.() -> Unit) {
        val toBeMapped = HostNetworkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.hostNetwork = mapped
    }

    /**
     * @param value InfrastructureNetwork config to deploy AzureStackHCI Cluster.
     */
    @JvmName("aftjcrhycxxdxjex")
    public suspend fun infrastructureNetwork(`value`: List<InfrastructureNetworkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructureNetwork = mapped
    }

    /**
     * @param argument InfrastructureNetwork config to deploy AzureStackHCI Cluster.
     */
    @JvmName("yfwrrfsesbwmxshy")
    public suspend
    fun infrastructureNetwork(argument: List<suspend InfrastructureNetworkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InfrastructureNetworkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.infrastructureNetwork = mapped
    }

    /**
     * @param argument InfrastructureNetwork config to deploy AzureStackHCI Cluster.
     */
    @JvmName("fwddqoqwayicwlxe")
    public suspend fun infrastructureNetwork(
        vararg
        argument: suspend InfrastructureNetworkArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InfrastructureNetworkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.infrastructureNetwork = mapped
    }

    /**
     * @param argument InfrastructureNetwork config to deploy AzureStackHCI Cluster.
     */
    @JvmName("xoxafriofkcbjagj")
    public suspend
    fun infrastructureNetwork(argument: suspend InfrastructureNetworkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InfrastructureNetworkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.infrastructureNetwork = mapped
    }

    /**
     * @param values InfrastructureNetwork config to deploy AzureStackHCI Cluster.
     */
    @JvmName("tbpidniysrwrdecq")
    public suspend fun infrastructureNetwork(vararg values: InfrastructureNetworkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.infrastructureNetwork = mapped
    }

    /**
     * @param value naming prefix to deploy cluster.
     */
    @JvmName("jcmfqjtkxqsrhspm")
    public suspend fun namingPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namingPrefix = mapped
    }

    /**
     * @param value Observability config to deploy AzureStackHCI Cluster.
     */
    @JvmName("refsfiqkkcgyxaea")
    public suspend fun observability(`value`: ObservabilityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.observability = mapped
    }

    /**
     * @param argument Observability config to deploy AzureStackHCI Cluster.
     */
    @JvmName("vbihqqgpypflhenn")
    public suspend fun observability(argument: suspend ObservabilityArgsBuilder.() -> Unit) {
        val toBeMapped = ObservabilityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.observability = mapped
    }

    /**
     * @param value OptionalServices config to deploy AzureStackHCI Cluster.
     */
    @JvmName("fmbiywnbvgewpvnn")
    public suspend fun optionalServices(`value`: OptionalServicesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optionalServices = mapped
    }

    /**
     * @param argument OptionalServices config to deploy AzureStackHCI Cluster.
     */
    @JvmName("xdcwcfbsijmntson")
    public suspend fun optionalServices(argument: suspend OptionalServicesArgsBuilder.() -> Unit) {
        val toBeMapped = OptionalServicesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.optionalServices = mapped
    }

    /**
     * @param value list of physical nodes config to deploy AzureStackHCI Cluster.
     */
    @JvmName("eqlvxumafotyaiwa")
    public suspend fun physicalNodes(`value`: List<PhysicalNodesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.physicalNodes = mapped
    }

    /**
     * @param argument list of physical nodes config to deploy AzureStackHCI Cluster.
     */
    @JvmName("ijepgeyiunmmvtuj")
    public suspend fun physicalNodes(argument: List<suspend PhysicalNodesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PhysicalNodesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.physicalNodes = mapped
    }

    /**
     * @param argument list of physical nodes config to deploy AzureStackHCI Cluster.
     */
    @JvmName("bmuseoiestrwxsww")
    public suspend fun physicalNodes(vararg argument: suspend PhysicalNodesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PhysicalNodesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.physicalNodes = mapped
    }

    /**
     * @param argument list of physical nodes config to deploy AzureStackHCI Cluster.
     */
    @JvmName("pndqqjrdtbgveqgk")
    public suspend fun physicalNodes(argument: suspend PhysicalNodesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PhysicalNodesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.physicalNodes = mapped
    }

    /**
     * @param values list of physical nodes config to deploy AzureStackHCI Cluster.
     */
    @JvmName("cxqnwtqhnaydiubl")
    public suspend fun physicalNodes(vararg values: PhysicalNodesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.physicalNodes = mapped
    }

    /**
     * @param value The URI to the keyvault / secret store.
     */
    @JvmName("vdjhokdvokuelffb")
    public suspend fun secretsLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretsLocation = mapped
    }

    /**
     * @param value SecuritySettings to deploy AzureStackHCI Cluster.
     */
    @JvmName("ceuhpqepijqhdaxc")
    public suspend fun securitySettings(`value`: SecuritySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securitySettings = mapped
    }

    /**
     * @param argument SecuritySettings to deploy AzureStackHCI Cluster.
     */
    @JvmName("magvtepoeygfdkkm")
    public suspend fun securitySettings(argument: suspend SecuritySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = SecuritySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securitySettings = mapped
    }

    /**
     * @param value Storage config to deploy AzureStackHCI Cluster.
     */
    @JvmName("gvadbkalsmkgfkiu")
    public suspend fun storage(`value`: StorageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storage = mapped
    }

    /**
     * @param argument Storage config to deploy AzureStackHCI Cluster.
     */
    @JvmName("mqraygwvoegrtcxf")
    public suspend fun storage(argument: suspend StorageArgsBuilder.() -> Unit) {
        val toBeMapped = StorageArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storage = mapped
    }

    internal fun build(): DeploymentDataArgs = DeploymentDataArgs(
        adouPath = adouPath,
        cluster = cluster,
        domainFqdn = domainFqdn,
        hostNetwork = hostNetwork,
        infrastructureNetwork = infrastructureNetwork,
        namingPrefix = namingPrefix,
        observability = observability,
        optionalServices = optionalServices,
        physicalNodes = physicalNodes,
        secretsLocation = secretsLocation,
        securitySettings = securitySettings,
        storage = storage,
    )
}
