@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.OptionalServicesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The OptionalServices of AzureStackHCI Cluster.
 * @property customLocation The name of custom location.
 */
public data class OptionalServicesArgs(
    public val customLocation: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.OptionalServicesArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.OptionalServicesArgs =
        com.pulumi.azurenative.azurestackhci.inputs.OptionalServicesArgs.builder()
            .customLocation(customLocation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OptionalServicesArgs].
 */
@PulumiTagMarker
public class OptionalServicesArgsBuilder internal constructor() {
    private var customLocation: Output<String>? = null

    /**
     * @param value The name of custom location.
     */
    @JvmName("jhojkslrraihjunv")
    public suspend fun customLocation(`value`: Output<String>) {
        this.customLocation = value
    }

    /**
     * @param value The name of custom location.
     */
    @JvmName("uesadvefeflfnvny")
    public suspend fun customLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customLocation = mapped
    }

    internal fun build(): OptionalServicesArgs = OptionalServicesArgs(
        customLocation = customLocation,
    )
}
