@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.QosPolicyOverridesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The QoSPolicyOverrides of a cluster.
 * @property bandwidthPercentageSMB This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
 * @property priorityValue8021ActionCluster This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
 * @property priorityValue8021ActionSMB This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
 */
public data class QosPolicyOverridesArgs(
    public val bandwidthPercentageSMB: Output<String>? = null,
    public val priorityValue8021ActionCluster: Output<String>? = null,
    public val priorityValue8021ActionSMB: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.QosPolicyOverridesArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.QosPolicyOverridesArgs =
        com.pulumi.azurenative.azurestackhci.inputs.QosPolicyOverridesArgs.builder()
            .bandwidthPercentageSMB(bandwidthPercentageSMB?.applyValue({ args0 -> args0 }))
            .priorityValue8021ActionCluster(priorityValue8021ActionCluster?.applyValue({ args0 -> args0 }))
            .priorityValue8021ActionSMB(priorityValue8021ActionSMB?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QosPolicyOverridesArgs].
 */
@PulumiTagMarker
public class QosPolicyOverridesArgsBuilder internal constructor() {
    private var bandwidthPercentageSMB: Output<String>? = null

    private var priorityValue8021ActionCluster: Output<String>? = null

    private var priorityValue8021ActionSMB: Output<String>? = null

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
     */
    @JvmName("lollxivewixlimnr")
    public suspend fun bandwidthPercentageSMB(`value`: Output<String>) {
        this.bandwidthPercentageSMB = value
    }

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
     */
    @JvmName("lgoyieiahhsjffcu")
    public suspend fun priorityValue8021ActionCluster(`value`: Output<String>) {
        this.priorityValue8021ActionCluster = value
    }

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
     */
    @JvmName("kdhebuefxnwvxfqo")
    public suspend fun priorityValue8021ActionSMB(`value`: Output<String>) {
        this.priorityValue8021ActionSMB = value
    }

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
     */
    @JvmName("ogylhygnfeifmbmm")
    public suspend fun bandwidthPercentageSMB(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidthPercentageSMB = mapped
    }

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
     */
    @JvmName("phmgbxxkggbiwrta")
    public suspend fun priorityValue8021ActionCluster(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priorityValue8021ActionCluster = mapped
    }

    /**
     * @param value This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation.
     */
    @JvmName("rjgwcafmyslwtruw")
    public suspend fun priorityValue8021ActionSMB(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priorityValue8021ActionSMB = mapped
    }

    internal fun build(): QosPolicyOverridesArgs = QosPolicyOverridesArgs(
        bandwidthPercentageSMB = bandwidthPercentageSMB,
        priorityValue8021ActionCluster = priorityValue8021ActionCluster,
        priorityValue8021ActionSMB = priorityValue8021ActionSMB,
    )
}
