@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.RouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Route - Route resource.
 * @property addressPrefix The destination CIDR to which the route applies.
 * @property name Name - name of the subnet
 * @property nextHopIpAddress The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
 */
public data class RouteArgs(
    public val addressPrefix: Output<String>? = null,
    public val name: Output<String>? = null,
    public val nextHopIpAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.RouteArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.RouteArgs =
        com.pulumi.azurenative.azurestackhci.inputs.RouteArgs.builder()
            .addressPrefix(addressPrefix?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .nextHopIpAddress(nextHopIpAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RouteArgs].
 */
@PulumiTagMarker
public class RouteArgsBuilder internal constructor() {
    private var addressPrefix: Output<String>? = null

    private var name: Output<String>? = null

    private var nextHopIpAddress: Output<String>? = null

    /**
     * @param value The destination CIDR to which the route applies.
     */
    @JvmName("qjbgmgwmhtwnyihu")
    public suspend fun addressPrefix(`value`: Output<String>) {
        this.addressPrefix = value
    }

    /**
     * @param value Name - name of the subnet
     */
    @JvmName("xbmbninbjwnhhcwv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
     */
    @JvmName("bxdosopcxfcxibav")
    public suspend fun nextHopIpAddress(`value`: Output<String>) {
        this.nextHopIpAddress = value
    }

    /**
     * @param value The destination CIDR to which the route applies.
     */
    @JvmName("sroflapjfjwxkjhj")
    public suspend fun addressPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addressPrefix = mapped
    }

    /**
     * @param value Name - name of the subnet
     */
    @JvmName("hpshiurghbsbgdam")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.
     */
    @JvmName("tstutyxxjlybkhii")
    public suspend fun nextHopIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nextHopIpAddress = mapped
    }

    internal fun build(): RouteArgs = RouteArgs(
        addressPrefix = addressPrefix,
        name = name,
        nextHopIpAddress = nextHopIpAddress,
    )
}
