@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.ScaleUnitsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Scale units will contains list of deployment data
 * @property deploymentData Deployment Data to deploy AzureStackHCI Cluster.
 */
public data class ScaleUnitsArgs(
    public val deploymentData: Output<DeploymentDataArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.ScaleUnitsArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.ScaleUnitsArgs =
        com.pulumi.azurenative.azurestackhci.inputs.ScaleUnitsArgs.builder()
            .deploymentData(
                deploymentData.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ScaleUnitsArgs].
 */
@PulumiTagMarker
public class ScaleUnitsArgsBuilder internal constructor() {
    private var deploymentData: Output<DeploymentDataArgs>? = null

    /**
     * @param value Deployment Data to deploy AzureStackHCI Cluster.
     */
    @JvmName("qwcqcaeptyjvgbbh")
    public suspend fun deploymentData(`value`: Output<DeploymentDataArgs>) {
        this.deploymentData = value
    }

    /**
     * @param value Deployment Data to deploy AzureStackHCI Cluster.
     */
    @JvmName("djsmlgvuiuhnpovt")
    public suspend fun deploymentData(`value`: DeploymentDataArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deploymentData = mapped
    }

    /**
     * @param argument Deployment Data to deploy AzureStackHCI Cluster.
     */
    @JvmName("kbosjrjhcvlaiwsy")
    public suspend fun deploymentData(argument: suspend DeploymentDataArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deploymentData = mapped
    }

    internal fun build(): ScaleUnitsArgs = ScaleUnitsArgs(
        deploymentData = deploymentData ?: throw PulumiNullFieldException("deploymentData"),
    )
}
