@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.StepArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Progress representation of the update run steps.
 * @property description More detailed description of the step.
 * @property endTimeUtc When the step reached a terminal state.
 * @property errorMessage Error message, specified if the step is in a failed state.
 * @property lastUpdatedTimeUtc Completion time of this step or the last completed sub-step.
 * @property name Name of the step.
 * @property startTimeUtc When the step started, or empty if it has not started executing.
 * @property status Status of the step, bubbled up from the ECE action plan for installation attempts. Values are: 'Success', 'Error', 'InProgress', and 'Unknown status'.
 * @property steps Recursive model for child steps of this step.
 */
public data class StepArgs(
    public val description: Output<String>? = null,
    public val endTimeUtc: Output<String>? = null,
    public val errorMessage: Output<String>? = null,
    public val lastUpdatedTimeUtc: Output<String>? = null,
    public val name: Output<String>? = null,
    public val startTimeUtc: Output<String>? = null,
    public val status: Output<String>? = null,
    public val steps: Output<List<StepArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.StepArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.StepArgs =
        com.pulumi.azurenative.azurestackhci.inputs.StepArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .endTimeUtc(endTimeUtc?.applyValue({ args0 -> args0 }))
            .errorMessage(errorMessage?.applyValue({ args0 -> args0 }))
            .lastUpdatedTimeUtc(lastUpdatedTimeUtc?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .startTimeUtc(startTimeUtc?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .steps(
                steps?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [StepArgs].
 */
@PulumiTagMarker
public class StepArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var endTimeUtc: Output<String>? = null

    private var errorMessage: Output<String>? = null

    private var lastUpdatedTimeUtc: Output<String>? = null

    private var name: Output<String>? = null

    private var startTimeUtc: Output<String>? = null

    private var status: Output<String>? = null

    private var steps: Output<List<StepArgs>>? = null

    /**
     * @param value More detailed description of the step.
     */
    @JvmName("hxsohweedxnyjabf")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value When the step reached a terminal state.
     */
    @JvmName("wxtusklpwbdyvekh")
    public suspend fun endTimeUtc(`value`: Output<String>) {
        this.endTimeUtc = value
    }

    /**
     * @param value Error message, specified if the step is in a failed state.
     */
    @JvmName("myygcnexwthdvhcq")
    public suspend fun errorMessage(`value`: Output<String>) {
        this.errorMessage = value
    }

    /**
     * @param value Completion time of this step or the last completed sub-step.
     */
    @JvmName("medaavpxekgamuop")
    public suspend fun lastUpdatedTimeUtc(`value`: Output<String>) {
        this.lastUpdatedTimeUtc = value
    }

    /**
     * @param value Name of the step.
     */
    @JvmName("npcliiivcgyfxtik")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value When the step started, or empty if it has not started executing.
     */
    @JvmName("fdopihslenigywpn")
    public suspend fun startTimeUtc(`value`: Output<String>) {
        this.startTimeUtc = value
    }

    /**
     * @param value Status of the step, bubbled up from the ECE action plan for installation attempts. Values are: 'Success', 'Error', 'InProgress', and 'Unknown status'.
     */
    @JvmName("iwvhmflkvhopjmhx")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Recursive model for child steps of this step.
     */
    @JvmName("hffstdlrytyobjeb")
    public suspend fun steps(`value`: Output<List<StepArgs>>) {
        this.steps = value
    }

    @JvmName("iugtsnmamxwysenq")
    public suspend fun steps(vararg values: Output<StepArgs>) {
        this.steps = Output.all(values.asList())
    }

    /**
     * @param values Recursive model for child steps of this step.
     */
    @JvmName("ortxexbwhopuaeff")
    public suspend fun steps(values: List<Output<StepArgs>>) {
        this.steps = Output.all(values)
    }

    /**
     * @param value More detailed description of the step.
     */
    @JvmName("iqggjndiwgdeqwah")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value When the step reached a terminal state.
     */
    @JvmName("qpvpgaujccgklrrv")
    public suspend fun endTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endTimeUtc = mapped
    }

    /**
     * @param value Error message, specified if the step is in a failed state.
     */
    @JvmName("ycqxguynbswfaksn")
    public suspend fun errorMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorMessage = mapped
    }

    /**
     * @param value Completion time of this step or the last completed sub-step.
     */
    @JvmName("intvcfmyjjaeomaq")
    public suspend fun lastUpdatedTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastUpdatedTimeUtc = mapped
    }

    /**
     * @param value Name of the step.
     */
    @JvmName("kxgeojncfcgpvpen")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value When the step started, or empty if it has not started executing.
     */
    @JvmName("qdwdnqgxcrmgjdqc")
    public suspend fun startTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startTimeUtc = mapped
    }

    /**
     * @param value Status of the step, bubbled up from the ECE action plan for installation attempts. Values are: 'Success', 'Error', 'InProgress', and 'Unknown status'.
     */
    @JvmName("fafokqxcdonloias")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Recursive model for child steps of this step.
     */
    @JvmName("mrhroeqkyixfdttu")
    public suspend fun steps(`value`: List<StepArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.steps = mapped
    }

    /**
     * @param argument Recursive model for child steps of this step.
     */
    @JvmName("chahhoiyaxwgbrib")
    public suspend fun steps(argument: List<suspend StepArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { StepArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param argument Recursive model for child steps of this step.
     */
    @JvmName("xnpidgeouktipdgd")
    public suspend fun steps(vararg argument: suspend StepArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { StepArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param argument Recursive model for child steps of this step.
     */
    @JvmName("rmyfjsqxxathkild")
    public suspend fun steps(argument: suspend StepArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StepArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.steps = mapped
    }

    /**
     * @param values Recursive model for child steps of this step.
     */
    @JvmName("uyabhjlcmligmxtm")
    public suspend fun steps(vararg values: StepArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.steps = mapped
    }

    internal fun build(): StepArgs = StepArgs(
        description = description,
        endTimeUtc = endTimeUtc,
        errorMessage = errorMessage,
        lastUpdatedTimeUtc = lastUpdatedTimeUtc,
        name = name,
        startTimeUtc = startTimeUtc,
        status = status,
        steps = steps,
    )
}
