@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.StorageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The Storage config of AzureStackHCI Cluster.
 * @property configurationMode By default, this mode is set to Express and your storage is configured as per best practices based on the number of nodes in the cluster. Allowed values are 'Express','InfraOnly', 'KeepStorage'
 */
public data class StorageArgs(
    public val configurationMode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.StorageArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.StorageArgs =
        com.pulumi.azurenative.azurestackhci.inputs.StorageArgs.builder()
            .configurationMode(configurationMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageArgs].
 */
@PulumiTagMarker
public class StorageArgsBuilder internal constructor() {
    private var configurationMode: Output<String>? = null

    /**
     * @param value By default, this mode is set to Express and your storage is configured as per best practices based on the number of nodes in the cluster. Allowed values are 'Express','InfraOnly', 'KeepStorage'
     */
    @JvmName("querveiyxqiyaist")
    public suspend fun configurationMode(`value`: Output<String>) {
        this.configurationMode = value
    }

    /**
     * @param value By default, this mode is set to Express and your storage is configured as per best practices based on the number of nodes in the cluster. Allowed values are 'Express','InfraOnly', 'KeepStorage'
     */
    @JvmName("ddbavnecjkaodpoe")
    public suspend fun configurationMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configurationMode = mapped
    }

    internal fun build(): StorageArgs = StorageArgs(
        configurationMode = configurationMode,
    )
}
