@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.UpdatePrerequisiteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * If update State is HasPrerequisite, this property contains an array of objects describing prerequisite updates before installing this update. Otherwise, it is empty.
 * @property packageName Friendly name of the prerequisite.
 * @property updateType Updatable component type.
 * @property version Version of the prerequisite.
 */
public data class UpdatePrerequisiteArgs(
    public val packageName: Output<String>? = null,
    public val updateType: Output<String>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.UpdatePrerequisiteArgs> {
    override fun toJava(): com.pulumi.azurenative.azurestackhci.inputs.UpdatePrerequisiteArgs =
        com.pulumi.azurenative.azurestackhci.inputs.UpdatePrerequisiteArgs.builder()
            .packageName(packageName?.applyValue({ args0 -> args0 }))
            .updateType(updateType?.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UpdatePrerequisiteArgs].
 */
@PulumiTagMarker
public class UpdatePrerequisiteArgsBuilder internal constructor() {
    private var packageName: Output<String>? = null

    private var updateType: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Friendly name of the prerequisite.
     */
    @JvmName("bhhyelgwpbtroshq")
    public suspend fun packageName(`value`: Output<String>) {
        this.packageName = value
    }

    /**
     * @param value Updatable component type.
     */
    @JvmName("tqrqqpjhhvayauen")
    public suspend fun updateType(`value`: Output<String>) {
        this.updateType = value
    }

    /**
     * @param value Version of the prerequisite.
     */
    @JvmName("suvopovbosqkkmio")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Friendly name of the prerequisite.
     */
    @JvmName("ujxqtweojserktbo")
    public suspend fun packageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageName = mapped
    }

    /**
     * @param value Updatable component type.
     */
    @JvmName("fgxqradeoskievlr")
    public suspend fun updateType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateType = mapped
    }

    /**
     * @param value Version of the prerequisite.
     */
    @JvmName("ertiogkfduetghid")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): UpdatePrerequisiteArgs = UpdatePrerequisiteArgs(
        packageName = packageName,
        updateType = updateType,
        version = version,
    )
}
