@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesImageReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Which Image to use for the virtual machine instance
 * @property id Resource ID of the image
 */
public data class VirtualMachineInstancePropertiesImageReferenceArgs(
    public val id: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesImageReferenceArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesImageReferenceArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesImageReferenceArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VirtualMachineInstancePropertiesImageReferenceArgs].
 */
@PulumiTagMarker
public class VirtualMachineInstancePropertiesImageReferenceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Resource ID of the image
     */
    @JvmName("dnqkltsgjyrxlrfc")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Resource ID of the image
     */
    @JvmName("jvyxbyaefnyloutx")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): VirtualMachineInstancePropertiesImageReferenceArgs =
        VirtualMachineInstancePropertiesImageReferenceArgs(
            id = id,
        )
}
