@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.azurestackhci.kotlin.inputs

import com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesNetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * NetworkProfile - describes the network configuration the virtual machine instance
 * @property networkInterfaces NetworkInterfaces - list of network interfaces to be attached to the virtual machine instance
 */
public data class VirtualMachineInstancePropertiesNetworkProfileArgs(
    public val networkInterfaces: Output<List<VirtualMachineInstancePropertiesNetworkInterfacesArgs>>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesNetworkProfileArgs> {
    override fun toJava():
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesNetworkProfileArgs =
        com.pulumi.azurenative.azurestackhci.inputs.VirtualMachineInstancePropertiesNetworkProfileArgs.builder()
            .networkInterfaces(
                networkInterfaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VirtualMachineInstancePropertiesNetworkProfileArgs].
 */
@PulumiTagMarker
public class VirtualMachineInstancePropertiesNetworkProfileArgsBuilder internal constructor() {
    private var networkInterfaces:
        Output<List<VirtualMachineInstancePropertiesNetworkInterfacesArgs>>? = null

    /**
     * @param value NetworkInterfaces - list of network interfaces to be attached to the virtual machine instance
     */
    @JvmName("yscsknlyxnoexafo")
    public suspend
    fun networkInterfaces(`value`: Output<List<VirtualMachineInstancePropertiesNetworkInterfacesArgs>>) {
        this.networkInterfaces = value
    }

    @JvmName("fawlggmfutaotnub")
    public suspend fun networkInterfaces(
        vararg
        values: Output<VirtualMachineInstancePropertiesNetworkInterfacesArgs>,
    ) {
        this.networkInterfaces = Output.all(values.asList())
    }

    /**
     * @param values NetworkInterfaces - list of network interfaces to be attached to the virtual machine instance
     */
    @JvmName("cvhoryfynhvoawua")
    public suspend
    fun networkInterfaces(values: List<Output<VirtualMachineInstancePropertiesNetworkInterfacesArgs>>) {
        this.networkInterfaces = Output.all(values)
    }

    /**
     * @param value NetworkInterfaces - list of network interfaces to be attached to the virtual machine instance
     */
    @JvmName("nhmlnbkadblpkfjk")
    public suspend
    fun networkInterfaces(`value`: List<VirtualMachineInstancePropertiesNetworkInterfacesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    /**
     * @param argument NetworkInterfaces - list of network interfaces to be attached to the virtual machine instance
     */
    @JvmName("fgixouunwwjyvsux")
    public suspend
    fun networkInterfaces(argument: List<suspend VirtualMachineInstancePropertiesNetworkInterfacesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VirtualMachineInstancePropertiesNetworkInterfacesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument NetworkInterfaces - list of network interfaces to be attached to the virtual machine instance
     */
    @JvmName("vkijcrpnbrdroask")
    public suspend fun networkInterfaces(
        vararg
        argument: suspend VirtualMachineInstancePropertiesNetworkInterfacesArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VirtualMachineInstancePropertiesNetworkInterfacesArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param argument NetworkInterfaces - list of network interfaces to be attached to the virtual machine instance
     */
    @JvmName("sxoslsdetpnjsmhw")
    public suspend
    fun networkInterfaces(argument: suspend VirtualMachineInstancePropertiesNetworkInterfacesArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                VirtualMachineInstancePropertiesNetworkInterfacesArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.networkInterfaces = mapped
    }

    /**
     * @param values NetworkInterfaces - list of network interfaces to be attached to the virtual machine instance
     */
    @JvmName("jubiwarkoylsjdpt")
    public suspend fun networkInterfaces(
        vararg
        values: VirtualMachineInstancePropertiesNetworkInterfacesArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkInterfaces = mapped
    }

    internal fun build(): VirtualMachineInstancePropertiesNetworkProfileArgs =
        VirtualMachineInstancePropertiesNetworkProfileArgs(
            networkInterfaces = networkInterfaces,
        )
}
